/*
 * Decompiled with CFR 0.152.
 */
package regius.gui;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JPlusMinusField
extends JPanel {
    private static final long serialVersionUID = -5937922953585345845L;
    private JTextField tf = new JTextField();
    private JButton btn_sub = new JButton("-");
    private JButton btn_add = new JButton("+");
    private boolean editable = true;
    private int minValue;
    private int maxValue;
    private boolean limitValue = false;

    public JPlusMinusField(int field_size, int button_size, ActionListener actionListener, int minValue, int maxValue) {
        this(field_size, button_size, actionListener);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.limitValue = true;
    }

    public JPlusMinusField(int field_size, int button_size, ActionListener actionListener) {
        this.setLayout(new FlowLayout(1, 0, 0));
        this.add(this.tf);
        this.add(this.btn_sub);
        this.add(this.btn_add);
        this.configure_btn(this.btn_sub, button_size, actionListener);
        this.configure_btn(this.btn_add, button_size, actionListener);
        this.tf.setEditable(false);
        this.tf.setPreferredSize(new Dimension(field_size, button_size));
    }

    private void configure_btn(JButton btn, int size, ActionListener actionListener) {
        btn.addActionListener(actionListener);
        btn.setPreferredSize(new Dimension(size, size));
        btn.setMargin(new Insets(0, 0, 0, 0));
    }

    public void setComponentsEditable(boolean editable) {
        this.editable = editable;
        this.tf.setEditable(editable);
        this.btn_add.setEnabled(editable);
        this.btn_sub.setEnabled(editable);
    }

    public void setValue(int i) {
        int newValue = i;
        if (this.limitValue && this.editable) {
            if (newValue <= this.minValue) {
                newValue = this.minValue;
                this.btn_sub.setEnabled(false);
            } else {
                this.btn_sub.setEnabled(true);
            }
            if (newValue >= this.maxValue) {
                newValue = this.maxValue;
                this.btn_add.setEnabled(false);
            } else {
                this.btn_add.setEnabled(true);
            }
        }
        this.tf.setText(Integer.toString(newValue));
    }

    public String getValueAsString() {
        return this.tf.getText();
    }

    public int getValue() {
        int val;
        try {
            val = Integer.parseInt(this.tf.getText());
        }
        catch (NumberFormatException nfe) {
            val = 0;
        }
        return val;
    }

    public void setLimits(int minValue, int maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.limitValue = true;
    }

    public void removeLimits() {
        this.limitValue = false;
    }

    public Object getPlus() {
        return this.btn_add;
    }

    public Object getMinus() {
        return this.btn_sub;
    }
}

