/*
 * Decompiled with CFR 0.152.
 */
package regius.mapeditorimp1;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HexFormat;
import regius.mapeditorimp1.Goods;
import regius.mapeditorimp1.Main;
import regius.mapeditorimp1.SaveFile;
import regius.tools.Convert;
import regius.tools.Search;

public class Empire {
    private static byte[] patternBeforStations = HexFormat.of().parseHex("09000B000E0001");
    private static byte[] patternBeforTransports = HexFormat.of().parseHex("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF");
    private static byte[] patternAfterStorage = HexFormat.of().parseHex("03E703E703E7");
    private static byte[] patternFlagShort = HexFormat.of().parseHex("00FFFF");
    private static byte[][] pattern = new byte[][]{patternBeforTransports, patternAfterStorage, patternBeforStations};
    private byte nameLength;
    private byte[] name;
    private byte nation;
    private byte[] u01;
    private int money;
    private byte[] u02;
    private Goods storehouse;
    private byte[] u03;
    private int countStation;
    private byte[] u05;
    private ArrayList<Station> stations = new ArrayList();
    private byte[] u04;
    private boolean isDeadLandButNotFullConquered = false;
    private boolean isSzenario = false;

    public Empire(byte[] fullbyte, SaveFile savefile) {
        this.isSzenario = savefile.isSzenario();
        this.nameLength = fullbyte[0];
        this.name = Convert.subBytes(fullbyte, 1, this.nameLength);
        Main.log.logDebug("Empire.Empire(): read " + this.getName());
        int pos = 2 * this.nameLength + 2;
        this.nation = fullbyte[pos++];
        if (!Arrays.equals(patternFlagShort, Convert.subBytes(fullbyte, pos, 3))) {
            this.isDeadLandButNotFullConquered = true;
            Main.log.logDebug("Empire.Empire(): ... is dead. R.I.P.");
            this.countStation = 0;
            this.u01 = Convert.subBytes(fullbyte, pos, fullbyte.length - pos);
        } else {
            this.u01 = Convert.subBytes(fullbyte, pos + 3, 62);
            this.money = Convert.toInt(fullbyte[(pos += 65) + 3], fullbyte[pos + 2], fullbyte[pos + 1], fullbyte[pos]);
            pos += 4;
            ArrayList<Integer>[] searchResult = Search.search(fullbyte, pattern);
            if (searchResult[1].size() > 0) {
                int posBeginStorehouse = searchResult[1].get(0) - 60;
                this.u02 = Convert.subBytes(fullbyte, pos, posBeginStorehouse - pos);
                this.storehouse = new Goods(Convert.subBytes(fullbyte, posBeginStorehouse, 46));
                pos = posBeginStorehouse + 46;
            } else {
                Main.log.logError("Empire.Empire(): can't find storehouse for " + this.getName());
            }
            if (1 < searchResult[2].size()) {
                int posBeginStation = searchResult[2].get(1) + 74;
                this.u03 = Convert.subBytes(fullbyte, pos, posBeginStation - pos);
                this.countStation = Convert.toInt(fullbyte[posBeginStation + 1], fullbyte[posBeginStation]);
                this.u05 = Convert.subBytes(fullbyte, posBeginStation + 4, 8);
                int i = 0;
                while (i < this.countStation) {
                    this.stations.add(new Station(Convert.subBytes(fullbyte, posBeginStation + 12 + 76 * i, 76)));
                    ++i;
                }
                pos = posBeginStation + 12 + 76 * this.countStation;
            } else {
                Main.log.logError("Empire.Empire(): can't find stations for " + this.getName());
            }
            this.u04 = Convert.subBytes(fullbyte, pos, fullbyte.length - pos);
        }
    }

    public byte[] getFullByte() {
        ArrayList<Byte> byteList = new ArrayList<Byte>();
        byteList.add(this.nameLength);
        Convert.addBytes(byteList, this.name);
        byteList.add(this.nameLength);
        Convert.addBytes(byteList, this.name);
        byteList.add(this.nation);
        if (this.isDeadLandButNotFullConquered) {
            Convert.addBytes(byteList, this.u01);
        } else {
            Convert.addBytes(byteList, patternFlagShort);
            Convert.addBytes(byteList, this.u01);
            byteList.addAll(Convert.toBytes(this.money, 4, true));
            Convert.addBytes(byteList, this.u02);
            Convert.addBytes(byteList, this.storehouse.getFullbyte());
            Convert.addBytes(byteList, this.u03);
            byteList.addAll(Convert.toBytes(this.countStation, 2, true));
            byteList.add((byte)0);
            byteList.add((byte)0);
            Convert.addBytes(byteList, this.u05);
            for (Station station : this.stations) {
                Convert.addBytes(byteList, station.getFullByte());
            }
            Convert.addBytes(byteList, this.u04);
        }
        return Convert.toBytes(byteList);
    }

    public byte getNation() {
        return this.nation;
    }

    private void removeStation(int fieldId) {
        boolean searchStation = true;
        int i = 0;
        while (searchStation && i < this.stations.size()) {
            if (this.stations.get((int)i).fieldId == fieldId) {
                this.stations.remove(i);
                --this.countStation;
                searchStation = false;
            }
            ++i;
        }
    }

    private void addStation(int fieldId, boolean harbor, boolean railwaystation) {
        Station station = new Station(this.nation, fieldId);
        station.setHarbor(harbor);
        station.setRailwaystation(railwaystation);
        this.stations.add(station);
        ++this.countStation;
    }

    public void modifyStation(int fieldId, boolean harbor, boolean railwaystation) {
        if (harbor || railwaystation) {
            boolean searchStation = true;
            int i = 0;
            while (searchStation && i < this.stations.size()) {
                Station station = this.stations.get(i);
                if (station.fieldId == fieldId) {
                    station.setHarbor(harbor);
                    station.setRailwaystation(railwaystation);
                    searchStation = false;
                }
                ++i;
            }
            if (searchStation) {
                this.addStation(fieldId, harbor, railwaystation);
            }
        } else {
            this.removeStation(fieldId);
        }
    }

    public String getName() {
        byte[] realName = !this.isSzenario && this.name[0] == 119 ? Convert.subBytes(this.name, 1, this.nameLength - 1) : this.name;
        return Convert.textISOtoUTF8_force(realName);
    }

    public boolean isDeadLandButNotFullConquered() {
        return this.isDeadLandButNotFullConquered;
    }

    public int getMoney() {
        return this.money;
    }

    public void setMoney(int money) {
        this.money = money;
    }

    public Goods getStorehouse() {
        return this.storehouse;
    }

    private class Station {
        private byte[] u01;
        private int fieldId;
        private byte[] u02;
        private byte nation;
        private byte[] u03;
        private byte harbor;
        private byte u04;
        private byte railwaystation;
        private byte[] u05;

        public Station(byte[] fullbyte) {
            this.u01 = Convert.subBytes(fullbyte, 0, 8);
            this.fieldId = Convert.toInt(fullbyte[9], fullbyte[8]);
            this.u02 = Convert.subBytes(fullbyte, 10, 6);
            this.nation = fullbyte[16];
            this.u03 = Convert.subBytes(fullbyte, 17, 48);
            this.harbor = fullbyte[65];
            this.u04 = fullbyte[66];
            this.railwaystation = fullbyte[67];
            this.u05 = Convert.subBytes(fullbyte, 68, 8);
        }

        public Station(byte nation, int feldNr) {
            this.u01 = new byte[8];
            this.fieldId = feldNr;
            this.u02 = new byte[6];
            this.nation = nation;
            this.u03 = new byte[48];
            this.u03[47] = 1;
            this.harbor = 0;
            this.u04 = 0;
            this.railwaystation = 0;
            this.u05 = new byte[8];
        }

        public byte[] getFullByte() {
            ArrayList<Byte> blist = new ArrayList<Byte>();
            ArrayList<Object> tmplist = new ArrayList();
            Convert.addBytes(blist, this.u01);
            tmplist = Convert.toBytes(this.fieldId, 2);
            blist.add((Byte)tmplist.get(1));
            blist.add((Byte)tmplist.get(0));
            Convert.addBytes(blist, this.u02);
            blist.add(this.nation);
            Convert.addBytes(blist, this.u03);
            blist.add(this.harbor);
            blist.add(this.u04);
            blist.add(this.railwaystation);
            Convert.addBytes(blist, this.u05);
            return Convert.toBytes(blist);
        }

        public void setHarbor(boolean exist) {
            this.harbor = exist ? (byte)1 : 0;
        }

        public void setRailwaystation(boolean exist) {
            this.railwaystation = exist ? (byte)1 : 0;
        }
    }
}

