/*
 * Decompiled with CFR 0.152.
 */
package regius.mapeditorimp1;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.BitSet;
import regius.mapeditorimp1.Enums;
import regius.mapeditorimp1.Fieldtypes;
import regius.mapeditorimp1.Main;
import regius.mapeditorimp1.Province;
import regius.tools.Convert;

public class Field {
    private static Point center = new Point(31, 31);
    private static Polygon landPolygonNE;
    private static Polygon landPolygonE;
    private static Polygon landPolygonSE;
    private static Polygon landPolygonSW;
    private static Polygon landPolygonW;
    private static Polygon landPolygonNW;
    private static Polygon[] landPolygons;
    private static Point[] landPolygonEndpoints;
    private static Polygon shorePolygonNE;
    private static Polygon shorePolygonSE;
    private static Polygon shorePolygonS;
    private static Polygon shorePolygonSW;
    private static Polygon shorePolygonNW;
    private static Polygon shorePolygonN;
    private static Polygon[] shorePolygons;
    private Enums.TerrainUnderlay terrainUnderlay;
    private byte ocean_coastline;
    private byte river;
    private byte nationNr1;
    private byte nationNr2;
    private byte transportId;
    private BitSet railroad;
    private BitSet national_border;
    private BitSet province_border;
    private byte land_coastline;
    private BitSet adjacentCell;
    private BitSet adjacentCellHM;
    private Enums.Expansion expansion;
    private byte u13;
    private byte u14;
    private byte u15;
    private byte u16;
    private Enums.Resource resource1;
    private Enums.Resource resource2;
    private Enums.TerrainOverlay terrainOverlay;
    private int provinceId;
    private byte u22;
    private byte u23;
    private byte u24;
    private byte u25;
    private byte u26;
    private byte u27;
    private BitSet buildings;
    private byte u29;
    private byte u30;
    private byte u31;
    private byte u32;
    private byte u33;
    private byte u34;
    private byte u35;
    private Field[] fieldsSurrounding;
    private Province province;
    private BufferedImage bild = new BufferedImage(Main.fieldPixelMax, Main.fieldPixelMax, 1);

    static {
        int[] nArray = new int[3];
        nArray[0] = 31;
        landPolygonNE = new Polygon(new int[]{31, 31, 64}, nArray, 3);
        int[] nArray2 = new int[3];
        nArray2[0] = 31;
        nArray2[2] = 64;
        landPolygonE = new Polygon(new int[]{31, 64, 64}, nArray2, 3);
        landPolygonSE = new Polygon(new int[]{31, 64, 31}, new int[]{31, 64, 64}, 3);
        int[] nArray3 = new int[3];
        nArray3[0] = 31;
        nArray3[1] = 31;
        landPolygonSW = new Polygon(nArray3, new int[]{31, 64, 64}, 3);
        int[] nArray4 = new int[3];
        nArray4[0] = 31;
        int[] nArray5 = new int[3];
        nArray5[0] = 31;
        nArray5[1] = 64;
        landPolygonW = new Polygon(nArray4, nArray5, 3);
        int[] nArray6 = new int[3];
        nArray6[0] = 31;
        nArray6[2] = 31;
        int[] nArray7 = new int[3];
        nArray7[0] = 31;
        landPolygonNW = new Polygon(nArray6, nArray7, 3);
        landPolygons = new Polygon[]{landPolygonNE, landPolygonE, landPolygonSE, landPolygonSW, landPolygonW, landPolygonNW};
        landPolygonEndpoints = new Point[]{new Point(64, 0), new Point(64, 64), new Point(31, 64), new Point(0, 64), new Point(0, 0), new Point(31, 0)};
        int[] nArray8 = new int[4];
        nArray8[0] = 31;
        nArray8[3] = 31;
        shorePolygonNE = new Polygon(new int[]{31, 47, 64, 64}, nArray8, 4);
        shorePolygonSE = new Polygon(new int[]{31, 64, 64, 47}, new int[]{31, 31, 64, 64}, 4);
        shorePolygonS = new Polygon(new int[]{31, 47, 16}, new int[]{31, 64, 64}, 3);
        int[] nArray9 = new int[4];
        nArray9[0] = 31;
        nArray9[1] = 16;
        shorePolygonSW = new Polygon(nArray9, new int[]{31, 64, 64, 31}, 4);
        int[] nArray10 = new int[4];
        nArray10[0] = 31;
        nArray10[3] = 16;
        int[] nArray11 = new int[4];
        nArray11[0] = 31;
        nArray11[1] = 31;
        shorePolygonNW = new Polygon(nArray10, nArray11, 4);
        int[] nArray12 = new int[3];
        nArray12[0] = 31;
        shorePolygonN = new Polygon(new int[]{31, 16, 47}, nArray12, 3);
        shorePolygons = new Polygon[]{shorePolygonNE, shorePolygonSE, shorePolygonS, shorePolygonSW, shorePolygonNW, shorePolygonN};
    }

    public Field(byte[] fullbyte) {
        this.terrainUnderlay = this.terrainUnderlayFromByte(fullbyte[0]);
        this.ocean_coastline = fullbyte[1];
        this.river = fullbyte[2];
        this.nationNr1 = fullbyte[3];
        this.nationNr2 = fullbyte[4];
        this.transportId = fullbyte[5];
        this.railroad = Convert.toBitSet(fullbyte[6], 8);
        this.national_border = Convert.toBitSet(fullbyte[7], 8);
        this.province_border = Convert.toBitSet(fullbyte[8], 8);
        this.land_coastline = fullbyte[9];
        this.adjacentCell = Convert.toBitSet(fullbyte[10], 8);
        this.adjacentCellHM = Convert.toBitSet(fullbyte[11], 8);
        this.expansion = this.expansionFromByte(fullbyte[12]);
        this.u13 = fullbyte[13];
        this.u14 = fullbyte[14];
        this.u15 = fullbyte[15];
        this.u16 = fullbyte[16];
        this.resource1 = this.resourceFromByte(fullbyte[17]);
        this.resource2 = this.resourceFromByte(fullbyte[18]);
        this.terrainOverlay = this.terrainOverlayFromByte(fullbyte[19], this.terrainUnderlay, this.adjacentCellHM, this.ocean_coastline);
        this.provinceId = Convert.toInt(fullbyte[21], fullbyte[20]);
        this.u22 = fullbyte[22];
        this.u23 = fullbyte[23];
        this.u24 = fullbyte[24];
        this.u25 = fullbyte[25];
        this.u26 = fullbyte[26];
        this.u27 = fullbyte[27];
        this.buildings = Convert.toBitSet(fullbyte[28], 8);
        this.u29 = fullbyte[29];
        this.u30 = fullbyte[30];
        this.u31 = fullbyte[31];
        this.u32 = fullbyte[32];
        this.u33 = fullbyte[33];
        this.u34 = fullbyte[34];
        this.u35 = fullbyte[35];
    }

    public byte[] getFullByte() {
        byte[] b = new byte[36];
        b[0] = this.terrainUnderlayToByte();
        b[1] = this.ocean_coastline;
        b[2] = this.river;
        b[3] = this.nationNr1;
        b[4] = this.nationNr2;
        b[5] = this.transportId;
        b[6] = Convert.toByte(this.railroad);
        b[7] = Convert.toByte(this.national_border);
        b[8] = Convert.toByte(this.province_border);
        b[9] = this.land_coastline;
        b[10] = Convert.toByte(this.adjacentCell);
        b[11] = Convert.toByte(this.adjacentCellHM);
        b[12] = this.expansionToByte();
        b[13] = this.u13;
        b[14] = this.u14;
        b[15] = this.u15;
        b[16] = this.u16;
        b[17] = this.resourceToByte(this.resource1);
        b[18] = this.resourceToByte(this.resource2);
        b[19] = this.terrainOverlayToByte();
        ArrayList<Byte> blist = Convert.toBytes(this.provinceId, 2);
        b[20] = blist.get(1);
        b[21] = blist.get(0);
        b[22] = this.u22;
        b[23] = this.u23;
        b[24] = this.u24;
        b[25] = this.u25;
        b[26] = this.u26;
        b[27] = this.u27;
        b[28] = Convert.toByte(this.buildings);
        b[29] = this.u29;
        b[30] = this.u30;
        b[31] = this.u31;
        b[32] = this.u32;
        b[33] = this.u33;
        b[34] = this.u34;
        b[35] = this.u35;
        return b;
    }

    public void setFieldsSurrounding(Field[] fieldsSurrounding) {
        this.fieldsSurrounding = fieldsSurrounding;
        this.paintBild();
    }

    public Field[] getFieldsSurrounding() {
        return this.fieldsSurrounding;
    }

    public BufferedImage getBild() {
        return this.bild;
    }

    private void paintBild() {
        try {
            BufferedImage bi;
            Graphics g = this.bild.getGraphics();
            g.drawImage(Main.getTerrainOverlayImage(this.terrainOverlay), 0, 0, null);
            this.paintShore(g);
            this.paintBildTransition(g);
            this.paintBildTransitionHM(g);
            if (this.river != 0) {
                g.drawImage(Main.getRiverImage(this.river), 0, 0, null);
            }
            if (!this.railroad.isEmpty()) {
                int i = 0;
                while (i < 6) {
                    if (this.railroad.get(i)) {
                        g.drawImage(Main.getRailImage(i), 0, 0, null);
                    }
                    ++i;
                }
            }
            if ((bi = this.isGreatpowerProvincialCity() ? Main.getGreatpowerProvincialCityImage() : (this.isSmallpowerProvincialCity() ? Main.getSmallpowerProvincialCityImage() : (this.isGreatPowerCapitalCity() ? Main.getGreatPowerCapitalCityImage() : (this.isSmallpowerCapitalCity() ? Main.getSmallpowerCapitalCityImage() : null)))) != null) {
                g.drawImage(bi, 0, 0, null);
            }
            if (this.isFortress() && this.province != null) {
                bi = Main.getFortressImage(this.province.getStufe_festung());
                g.drawImage(bi, 0, 0, null);
            }
            if (this.isRailwayStation()) {
                bi = Main.getStationImage();
                g.drawImage(bi, 0, 0, null);
            }
            if (this.isHabor()) {
                bi = Main.getHarborImage();
                g.drawImage(Main.getHarborImage(), 0, 0, null);
            }
            if ((bi = Main.getResImage(this.resource1)) != null) {
                g.drawImage(bi, 10, 10, null);
                bi = Main.getResImage(this.resource2);
                if (bi != null) {
                    g.drawImage(bi, 10, 25, null);
                }
            }
        }
        catch (Exception e) {
            Main.log.logError(e);
        }
    }

    private void paintShore(Graphics g) {
        if (this.isOceanAndShore()) {
            int direction = 0;
            while (direction < 6) {
                BufferedImage bi = this.findRiverMouthImage(this.adjacentCellHM.get(direction), this.adjacentCellHM.get((direction + 1) % 6), direction);
                if (bi == null) {
                    bi = this.findShoreImage(this.adjacentCellHM.get(direction), this.adjacentCellHM.get((direction + 1) % 6), direction);
                }
                if (bi != null) {
                    g.setClip(shorePolygons[direction]);
                    g.drawImage(bi, 0, 0, null);
                    g.setClip(null);
                }
                ++direction;
            }
        }
    }

    private BufferedImage findRiverMouthImage(boolean neighbor1_isLand, boolean neighbor2_isLand, int direction) {
        Enums.ShoreImage shoreImage;
        block29: {
            block28: {
                boolean bothIsLand;
                shoreImage = Enums.ShoreImage.NO_IMAGE;
                boolean bl = bothIsLand = neighbor1_isLand && neighbor2_isLand;
                if (!bothIsLand) break block28;
                switch (this.river) {
                    case 51: {
                        if (direction == 0) {
                            shoreImage = Enums.ShoreImage.RiverMouth_Land_NE_SE_Wl_NW;
                            break;
                        }
                        break block29;
                    }
                    case 52: {
                        if (direction == 0) {
                            shoreImage = Enums.ShoreImage.RiverMouth_Land_Eh_El_SW_Wh;
                            break;
                        }
                        break block29;
                    }
                    case 53: {
                        if (direction == 1) {
                            shoreImage = Enums.ShoreImage.RiverMouth_Land_Eh_El_SW_Wh;
                            break;
                        }
                        break block29;
                    }
                    case 54: {
                        if (direction == 1 || direction == 2) {
                            shoreImage = Enums.ShoreImage.RiverMouth_Land_NE_SE_Wl_NW;
                            break;
                        }
                        break block29;
                    }
                    case 55: {
                        if (direction == 2 || direction == 3) {
                            shoreImage = Enums.ShoreImage.RiverMouth_Land_Eh_El_SW_Wh;
                            break;
                        }
                        break block29;
                    }
                    case 56: {
                        if (direction == 4) {
                            shoreImage = Enums.ShoreImage.RiverMouth_Land_Eh_El_SW_Wh;
                            break;
                        }
                        break block29;
                    }
                    case 57: {
                        if (direction == 3) {
                            shoreImage = Enums.ShoreImage.RiverMouth_Land_NE_SE_Wl_NW;
                            break;
                        }
                        break block29;
                    }
                    case 58: {
                        if (direction == 4) {
                            shoreImage = Enums.ShoreImage.RiverMouth_Land_NE_SE_Wl_NW;
                            break;
                        }
                        break block29;
                    }
                    default: {
                        shoreImage = Enums.ShoreImage.NO_IMAGE;
                        break;
                    }
                }
                break block29;
            }
            switch (this.river) {
                case 51: {
                    if (direction != 0) break;
                    shoreImage = Enums.ShoreImage.RiverMouth_Ocean_NE_SE_Wl_Wh;
                    break;
                }
                case 52: {
                    if (direction != 0) break;
                    shoreImage = Enums.ShoreImage.RiverMouth_Ocean_Eh_El_SW_NW;
                    break;
                }
                case 53: {
                    if (direction != 1) break;
                    shoreImage = Enums.ShoreImage.RiverMouth_Ocean_Eh_El_SW_NW;
                    break;
                }
                case 54: {
                    if (direction != 1 && direction != 2) break;
                    shoreImage = Enums.ShoreImage.RiverMouth_Ocean_NE_SE_Wl_Wh;
                    break;
                }
                case 55: {
                    if (direction != 2 && direction != 3) break;
                    shoreImage = Enums.ShoreImage.RiverMouth_Ocean_Eh_El_SW_NW;
                    break;
                }
                case 56: {
                    if (direction != 4) break;
                    shoreImage = Enums.ShoreImage.RiverMouth_Ocean_NE_SE_Wl_Wh;
                    break;
                }
                case 57: {
                    if (direction != 3) break;
                    shoreImage = Enums.ShoreImage.RiverMouth_Ocean_NE_SE_Wl_Wh;
                    break;
                }
                case 58: {
                    if (direction != 4) break;
                    shoreImage = Enums.ShoreImage.RiverMouth_Ocean_Eh_El_SW_NW;
                    break;
                }
                default: {
                    shoreImage = Enums.ShoreImage.NO_IMAGE;
                }
            }
        }
        return Main.getShore(shoreImage, false);
    }

    private BufferedImage findShoreImage(boolean neighbor1_isLand, boolean neighbor2_isLand, int direction) {
        Enums.ShoreImage shoreImage = neighbor1_isLand && neighbor2_isLand ? Enums.ShoreImage.Shore_Land : (!neighbor1_isLand && !neighbor2_isLand ? Enums.ShoreImage.NO_IMAGE : (neighbor1_isLand ? (direction % 2 == 0 ? Enums.ShoreImage.Shore_Ocean0 : Enums.ShoreImage.Shore_Ocean1) : (direction % 2 == 0 ? Enums.ShoreImage.Shore_Ocean1 : Enums.ShoreImage.Shore_Ocean0)));
        BitSet ocean_coastline_bitset = Convert.toBitSet(this.ocean_coastline, 8);
        boolean alternativImage = ocean_coastline_bitset.get(direction);
        return Main.getShore(shoreImage, alternativImage);
    }

    private void paintBildTransition(Graphics g) {
        if (!this.adjacentCell.isEmpty()) {
            this.paintBildTransition_internal(g, this.adjacentCell, Main.getTerrainOverlayTransitionImage(this.terrainOverlay));
        }
    }

    private void paintBildTransitionHM(Graphics g) {
        if (!this.adjacentCellHM.isEmpty()) {
            this.paintBildTransition_internal(g, this.adjacentCellHM, Main.getTerrainOverlayTransitionHMImage(this.terrainOverlay));
        }
    }

    private void paintBildTransition_internal(Graphics g, BitSet adjacentCell, BufferedImage bi) {
        if (bi != null) {
            boolean appendPoints = false;
            Polygon clip = null;
            int i = 0;
            while (i < adjacentCell.length()) {
                if (adjacentCell.get(i)) {
                    if (clip == null) {
                        Polygon landPolygon = landPolygons[i];
                        clip = new Polygon(landPolygon.xpoints, landPolygon.ypoints, landPolygon.npoints);
                        appendPoints = true;
                    } else if (appendPoints) {
                        Point landPolygonEndpoint = landPolygonEndpoints[i];
                        clip.addPoint(landPolygonEndpoint.x, landPolygonEndpoint.y);
                    } else {
                        clip.addPoint(Field.center.x, Field.center.y);
                        Point landPolygonLastEndpoint = landPolygonEndpoints[i - 1];
                        clip.addPoint(landPolygonLastEndpoint.x, landPolygonLastEndpoint.y);
                        Point landPolygonEndpoint = landPolygonEndpoints[i];
                        clip.addPoint(landPolygonEndpoint.x, landPolygonEndpoint.y);
                        appendPoints = true;
                    }
                } else {
                    appendPoints = false;
                }
                ++i;
            }
            g.setClip(clip);
            g.drawImage(bi, 0, 0, null);
            g.setClip(null);
        }
    }

    public void changeFieldByFieldType(Fieldtypes.Fieldtype ftl) {
        if (ftl != null) {
            this.setTerrain_over(ftl.terrain_over);
            this.setTerrain_under(ftl.terrain_under);
            this.setResource1(ftl.resource1);
            this.setResource2(ftl.resource2);
            this.setAdjacentCells();
            this.setExpansion(Enums.Expansion.L0);
            this.paintBild();
            Field[] fieldArray = this.fieldsSurrounding;
            int n = this.fieldsSurrounding.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                field.paintBild();
                ++n2;
            }
        }
    }

    public void setProvince(Province province) {
        byte festungStufeAlt = 0;
        if (this.province != null) {
            festungStufeAlt = this.province.getStufe_festung();
        }
        this.province = province;
        this.provinceId = province.getProvinceNumber();
        if (festungStufeAlt != province.getStufe_festung()) {
            this.paintBild();
        }
    }

    public Province getProvince() {
        return this.province;
    }

    public Enums.TerrainUnderlay getTerrainUnderlay() {
        return this.terrainUnderlay;
    }

    private void setTerrain_under(Enums.TerrainUnderlay terrainUnder) {
        this.terrainUnderlay = terrainUnder;
    }

    public boolean isOcean() {
        return Enums.TerrainUnderlay.OCEAN == this.terrainUnderlay;
    }

    public boolean isOceanAndShore() {
        return Enums.TerrainUnderlay.OCEAN == this.terrainUnderlay && !this.adjacentCellHM.isEmpty();
    }

    public boolean isOceanAndNotShore() {
        return Enums.TerrainUnderlay.OCEAN == this.terrainUnderlay && this.adjacentCellHM.isEmpty();
    }

    public boolean isMountain() {
        return Enums.TerrainUnderlay.MOUNTAIN == this.terrainUnderlay;
    }

    public boolean isHillOrWoolhill() {
        return Enums.TerrainUnderlay.HILL == this.terrainUnderlay;
    }

    public BitSet getRails() {
        return this.railroad;
    }

    public boolean isRail(int c) {
        return this.railroad.get(c);
    }

    public void setRailroad(int c, boolean b) {
        this.railroad.set(c, b);
        this.paintBild();
    }

    public boolean isFortress() {
        return this.buildings.get(3);
    }

    public void setFortress(boolean exist) {
        this.buildings.set(3, exist);
        this.paintBild();
    }

    public boolean isRailwayStation() {
        return this.buildings.get(4);
    }

    public void setRailwayStation(boolean exist) {
        this.buildings.set(4, exist);
        this.paintBild();
    }

    public boolean isHabor() {
        return this.buildings.get(2);
    }

    public void setHabor(boolean exist) {
        this.buildings.set(2, exist);
        this.paintBild();
    }

    public boolean isGreatPowerCapitalCity() {
        boolean b = false;
        if (this.buildings.get(0) && this.buildings.get(1)) {
            b = true;
        }
        return b;
    }

    public boolean isGreatpowerProvincialCity() {
        boolean b = false;
        if (this.isGreatPower() && !this.buildings.get(0) && this.buildings.get(1)) {
            b = true;
        }
        return b;
    }

    public boolean isSmallpowerCapitalCity() {
        boolean b = false;
        if (this.buildings.get(0) && !this.buildings.get(1)) {
            b = true;
        }
        return b;
    }

    public boolean isSmallpowerProvincialCity() {
        boolean b = false;
        if (!this.isGreatPower() && this.buildings.get(1)) {
            b = true;
        }
        return b;
    }

    public boolean isCity() {
        return this.isSmallpowerProvincialCity() || this.isGreatpowerProvincialCity() || this.isSmallpowerCapitalCity() || this.isGreatPowerCapitalCity();
    }

    public boolean isGreatPower() {
        return this.nationNr1 <= 6;
    }

    public byte getNationNr1() {
        return this.nationNr1;
    }

    public void setNationNr1(byte nationNr1) {
        this.nationNr1 = nationNr1;
    }

    public byte getNationNr2() {
        return this.nationNr2;
    }

    public void setNationNr2(byte nationNr2) {
        this.nationNr2 = nationNr2;
    }

    public int getProvinceId() {
        return this.provinceId;
    }

    public boolean getBit(int analyse_byte, int analyse_bit) {
        Boolean myreturn = false;
        byte[] bytes = this.getFullByte();
        myreturn = Convert.toBitSet(bytes[analyse_byte], 8).get(analyse_bit);
        return myreturn;
    }

    public void setAdjacentCell(int c, boolean b) {
        this.adjacentCell.set(c, b);
    }

    public void setAdjacentCellHM(int c, boolean b) {
        this.adjacentCellHM.set(c, b);
    }

    public boolean isProvincialBorder(int c) {
        return this.province_border.get(c);
    }

    public void setProvincialBorder(int c, boolean b) {
        this.province_border.set(c, b);
    }

    public boolean isNationalBorder(int c) {
        return this.national_border.get(c);
    }

    public void setNationalBorder(int c, boolean b) {
        this.national_border.set(c, b);
    }

    public boolean isRiver() {
        return this.river != 0;
    }

    public Enums.Resource getResource1() {
        return this.resource1;
    }

    public Enums.Resource getResource2() {
        return this.resource2;
    }

    private void setResource1(Enums.Resource resource1) {
        this.resource1 = resource1;
        this.paintBild();
    }

    private void setResource2(Enums.Resource resource2) {
        this.resource2 = resource2;
        this.paintBild();
    }

    public Enums.Expansion getExpansion() {
        return this.expansion;
    }

    public boolean previousExpansion() {
        return this.setExpansion(this.expansion.getPreviousExpansion());
    }

    public boolean nextExpansion() {
        return this.setExpansion(this.expansion.getNextExpansion());
    }

    public boolean setExpansion(Enums.Expansion expansion) {
        boolean isChanged = false;
        if (this.expansion != expansion) {
            this.expansion = expansion;
            this.paintBild();
            isChanged = true;
        }
        return isChanged;
    }

    public Enums.TerrainOverlay getTerrainOverlay() {
        return this.terrainOverlay;
    }

    private void setTerrain_over(Enums.TerrainOverlay terrainOver) {
        switch (terrainOver) {
            case MOUNTAIN_1: {
                this.ocean_coastline = 1;
                break;
            }
            case OCEAN_SANDBAR: {
                this.ocean_coastline = 1;
                break;
            }
            case OCEAN_ISLAND_SMALL: {
                this.ocean_coastline = (byte)2;
                break;
            }
            case OCEAN_ISLAND_LARGE: {
                this.ocean_coastline = (byte)3;
                break;
            }
            case OCEAN_ISLAND_GROUP: {
                this.ocean_coastline = (byte)4;
                break;
            }
            default: {
                if (this.isOceanAndShore()) break;
                this.ocean_coastline = 0;
            }
        }
        this.terrainOverlay = terrainOver;
    }

    public byte getTransportId() {
        return this.transportId;
    }

    public void setTransportId(byte transportNr) {
        this.transportId = transportNr;
    }

    private Enums.TerrainUnderlay terrainUnderlayFromByte(Byte byteValue) {
        Enums.TerrainUnderlay terrainUnderlay = Enums.TerrainUnderlay.GRAS;
        switch (byteValue) {
            case 0: {
                terrainUnderlay = Enums.TerrainUnderlay.GRAS;
                break;
            }
            case 1: {
                terrainUnderlay = Enums.TerrainUnderlay.FOREST;
                break;
            }
            case 2: {
                terrainUnderlay = Enums.TerrainUnderlay.HILL;
                break;
            }
            case 3: {
                terrainUnderlay = Enums.TerrainUnderlay.MOUNTAIN;
                break;
            }
            case 4: {
                terrainUnderlay = Enums.TerrainUnderlay.SWAMP;
                break;
            }
            case 5: {
                terrainUnderlay = Enums.TerrainUnderlay.OCEAN;
                break;
            }
            case 6: {
                terrainUnderlay = Enums.TerrainUnderlay.WASTELAND;
                break;
            }
            case 7: {
                terrainUnderlay = Enums.TerrainUnderlay.FARMLAND;
            }
        }
        return terrainUnderlay;
    }

    private byte terrainUnderlayToByte() {
        byte byteValue = 0;
        switch (this.terrainUnderlay) {
            case GRAS: {
                byteValue = 0;
                break;
            }
            case FOREST: {
                byteValue = 1;
                break;
            }
            case HILL: {
                byteValue = 2;
                break;
            }
            case MOUNTAIN: {
                byteValue = 3;
                break;
            }
            case SWAMP: {
                byteValue = 4;
                break;
            }
            case OCEAN: {
                byteValue = 5;
                break;
            }
            case WASTELAND: {
                byteValue = 6;
                break;
            }
            case FARMLAND: {
                byteValue = 7;
            }
        }
        return byteValue;
    }

    private Enums.TerrainOverlay terrainOverlayFromByte(Byte byteValue, Enums.TerrainUnderlay terrainUnderlay, BitSet adjacentCellHM, Byte ocean_coastline) {
        return switch (byteValue) {
            case 0 -> {
                if (!adjacentCellHM.isEmpty()) {
                    yield Enums.TerrainOverlay.OCEAN;
                }
                switch (ocean_coastline) {
                    case 1: {
                        yield Enums.TerrainOverlay.OCEAN_SANDBAR;
                    }
                    case 2: {
                        yield Enums.TerrainOverlay.OCEAN_ISLAND_SMALL;
                    }
                    case 3: {
                        yield Enums.TerrainOverlay.OCEAN_ISLAND_LARGE;
                    }
                    case 4: {
                        yield Enums.TerrainOverlay.OCEAN_ISLAND_GROUP;
                    }
                }
                yield Enums.TerrainOverlay.OCEAN;
            }
            case 1 -> Enums.TerrainOverlay.CLEAR;
            case 2 -> Enums.TerrainOverlay.COTTON;
            case 3 -> Enums.TerrainOverlay.CATTLE;
            case 4 -> Enums.TerrainOverlay.HORSE;
            case 5 -> Enums.TerrainOverlay.GRAIN;
            case 6 -> Enums.TerrainOverlay.ORCHARD;
            case 7 -> Enums.TerrainOverlay.WOOL;
            case 8 -> Enums.TerrainOverlay.HILL;
            case 9 -> {
                if (1 == ocean_coastline) {
                    yield Enums.TerrainOverlay.MOUNTAIN_1;
                }
                yield Enums.TerrainOverlay.MOUNTAIN_0;
            }
            case 10 -> Enums.TerrainOverlay.SWAMP;
            case 11 -> Enums.TerrainOverlay.DESERT;
            case 12 -> Enums.TerrainOverlay.TUNDRA;
            case 13 -> Enums.TerrainOverlay.FOREST;
            case 14 -> Enums.TerrainOverlay.CLEAR_TOWN;
            case 15 -> Enums.TerrainOverlay.SCRUB;
            default -> {
                Main.log.logError("Feld.terrainOverlayFromByte() value not expected: " + byteValue);
                yield Enums.TerrainOverlay.OCEAN;
            }
        };
    }

    private byte terrainOverlayToByte() {
        byte byteValue = 0;
        switch (this.terrainOverlay) {
            case OCEAN: {
                byteValue = 0;
                break;
            }
            case OCEAN_ISLAND_GROUP: {
                byteValue = 0;
                break;
            }
            case OCEAN_ISLAND_LARGE: {
                byteValue = 0;
                break;
            }
            case OCEAN_ISLAND_SMALL: {
                byteValue = 0;
                break;
            }
            case OCEAN_SANDBAR: {
                byteValue = 0;
                break;
            }
            case CLEAR: {
                byteValue = 1;
                break;
            }
            case COTTON: {
                byteValue = 2;
                break;
            }
            case CATTLE: {
                byteValue = 3;
                break;
            }
            case HORSE: {
                byteValue = 4;
                break;
            }
            case GRAIN: {
                byteValue = 5;
                break;
            }
            case ORCHARD: {
                byteValue = 6;
                break;
            }
            case WOOL: {
                byteValue = 7;
                break;
            }
            case HILL: {
                byteValue = 8;
                break;
            }
            case MOUNTAIN_0: {
                byteValue = 9;
                break;
            }
            case MOUNTAIN_1: {
                byteValue = 9;
                break;
            }
            case SWAMP: {
                byteValue = 10;
                break;
            }
            case DESERT: {
                byteValue = 11;
                break;
            }
            case TUNDRA: {
                byteValue = 12;
                break;
            }
            case FOREST: {
                byteValue = 13;
                break;
            }
            case CLEAR_TOWN: {
                byteValue = 14;
                break;
            }
            case SCRUB: {
                byteValue = 15;
                break;
            }
        }
        return byteValue;
    }

    private Enums.Resource resourceFromByte(Byte byteValue) {
        Enums.Resource res = Enums.Resource._EMPTY;
        switch (byteValue) {
            case 0: {
                res = Enums.Resource.COTTON;
                break;
            }
            case 1: {
                res = Enums.Resource.WOOL__;
                break;
            }
            case 2: {
                res = Enums.Resource.WOOD__;
                break;
            }
            case 3: {
                res = Enums.Resource.COAL__;
                break;
            }
            case 4: {
                res = Enums.Resource.IRON__;
                break;
            }
            case 5: {
                res = Enums.Resource.HORSE_;
                break;
            }
            case 6: {
                res = Enums.Resource.OIL___;
                break;
            }
            case 17: {
                res = Enums.Resource.GRAIN_;
                break;
            }
            case 18: {
                res = Enums.Resource.FRUIT_;
                break;
            }
            case 19: {
                res = Enums.Resource.FISH__;
                break;
            }
            case 20: {
                res = Enums.Resource.CATTLE;
                break;
            }
            case 21: {
                res = Enums.Resource.GEMS__;
                break;
            }
            case 22: {
                res = Enums.Resource.GOLD__;
                break;
            }
            case -1: {
                res = Enums.Resource._EMPTY;
                break;
            }
            default: {
                Main.log.logWarning("Field.resourceFromByte() unexpected byteValue " + byteValue);
                res = Enums.Resource._EMPTY;
            }
        }
        return res;
    }

    private byte resourceToByte(Enums.Resource resource) {
        int byteValue = 0;
        switch (resource) {
            case COTTON: {
                byteValue = 0;
                break;
            }
            case CATTLE: {
                byteValue = 20;
                break;
            }
            case COAL__: {
                byteValue = 3;
                break;
            }
            case FISH__: {
                byteValue = 19;
                break;
            }
            case FRUIT_: {
                byteValue = 18;
                break;
            }
            case GEMS__: {
                byteValue = 21;
                break;
            }
            case GOLD__: {
                byteValue = 22;
                break;
            }
            case GRAIN_: {
                byteValue = 17;
                break;
            }
            case HORSE_: {
                byteValue = 5;
                break;
            }
            case IRON__: {
                byteValue = 4;
                break;
            }
            case OIL___: {
                byteValue = 6;
                break;
            }
            case WOOD__: {
                byteValue = 2;
                break;
            }
            case WOOL__: {
                byteValue = 1;
                break;
            }
            case _EMPTY: {
                byteValue = -1;
                break;
            }
            default: {
                Main.log.logWarning("Field.resourceToByte() unexpected value " + (Object)((Object)resource));
                byteValue = -1;
            }
        }
        return (byte)byteValue;
    }

    private Enums.Expansion expansionFromByte(Byte byteValue) {
        if (15 < byteValue) {
            byteValue = (byte)(byteValue >> 4);
        }
        return switch (byteValue) {
            case 1 -> Enums.Expansion.L1;
            case 2 -> Enums.Expansion.L2;
            case 3 -> Enums.Expansion.L3;
            default -> Enums.Expansion.L0;
        };
    }

    private byte expansionToByte() {
        byte byteValue = switch (this.expansion) {
            case Enums.Expansion.L1 -> 1;
            case Enums.Expansion.L2 -> 2;
            case Enums.Expansion.L3 -> 3;
            default -> 0;
        };
        if (Enums.Expansion.L0 != this.expansion && this.expansionTypeIsMine()) {
            byteValue = (byte)(byteValue << 4);
        }
        return byteValue;
    }

    private boolean expansionTypeIsMine() {
        boolean isMine = false;
        if (Enums.TerrainOverlay.HILL == this.terrainOverlay || Enums.TerrainOverlay.MOUNTAIN_0 == this.terrainOverlay || Enums.TerrainOverlay.MOUNTAIN_1 == this.terrainOverlay || Enums.TerrainOverlay.SWAMP == this.terrainOverlay || Enums.TerrainOverlay.DESERT == this.terrainOverlay || Enums.TerrainOverlay.TUNDRA == this.terrainOverlay) {
            isMine = true;
        }
        return isMine;
    }

    private void setAdjacentCells() {
        int i = 0;
        while (i < this.fieldsSurrounding.length) {
            Field fi_tmp = this.fieldsSurrounding[i];
            if (!this.isOcean() && (this.terrainOverlay == fi_tmp.getTerrainOverlay() || this.isHillOrWoolhill() && fi_tmp.isHillOrWoolhill() || this.isMountain() && fi_tmp.isMountain())) {
                this.setAdjacentCell(i, true);
                fi_tmp.setAdjacentCell((i + 3) % 6, true);
            } else {
                this.setAdjacentCell(i, false);
                fi_tmp.setAdjacentCell((i + 3) % 6, false);
            }
            if (this.isHillOrWoolhill() && fi_tmp.isMountain() || this.isMountain() && fi_tmp.isHillOrWoolhill()) {
                this.setAdjacentCellHM(i, true);
                fi_tmp.setAdjacentCellHM((i + 3) % 6, true);
            } else if (this.isOcean() && !fi_tmp.isOcean()) {
                this.setAdjacentCellHM(i, true);
            } else if (!this.isOcean() && fi_tmp.isOcean()) {
                fi_tmp.setAdjacentCellHM((i + 3) % 6, true);
            } else {
                this.setAdjacentCellHM(i, false);
                fi_tmp.setAdjacentCellHM((i + 3) % 6, false);
            }
            ++i;
        }
    }
}

