/*
 * Decompiled with CFR 0.152.
 */
package regius.mapeditorimp1;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.text.NumberFormatter;
import regius.mapeditorimp1.Empire;
import regius.mapeditorimp1.Enums;
import regius.mapeditorimp1.Goods;
import regius.mapeditorimp1.Language;
import regius.mapeditorimp1.Main;
import regius.mapeditorimp1.Mapeditor;

public class Frame_Empire
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 6406400032262453551L;
    private static Frame_Empire instance;
    ArrayList<Empire> empiresAlive;
    private JTabbedPane tabbedPane;
    private HashMap<Enums.Resource, ArrayList<JFormattedTextField>> allResourceTextFields;
    private static NumberFormatter numberFormatterMoney;
    private static NumberFormatter numberFormatterResource;
    private JButton btn_confirm;

    static {
        numberFormatterMoney = Frame_Empire.createNumberFormatter(Integer.MIN_VALUE, Integer.MAX_VALUE);
        numberFormatterResource = Frame_Empire.createNumberFormatter(0, 32000);
    }

    private Frame_Empire(Mapeditor me) {
        Language language = Mapeditor.getLanguage();
        this.setTitle(language.getMEN_EMPIRE());
        this.setAlwaysOnTop(true);
        this.setDefaultCloseOperation(2);
        this.setIconImage(Main.getIcon());
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setTabLayoutPolicy(1);
        this.empiresAlive = me.getSavefile().getEmpiresAlive();
        this.tabbedPane.addTab(language.getMEN_STOREHOUSE(), this.makeStorehouse(language, this.empiresAlive));
        this.add((Component)this.tabbedPane, "North");
        this.pack();
        this.setLocationRelativeTo(me);
    }

    public static synchronized void exit() {
        if (instance != null) {
            instance.dispose();
            instance = null;
        }
    }

    public static synchronized Frame_Empire getInstance(Mapeditor me) {
        if (instance == null) {
            instance = new Frame_Empire(me);
        }
        return instance;
    }

    public void refreshLanguage(Language language) {
        this.setTitle(language.getMEN_EMPIRE());
        this.tabbedPane.setTitleAt(0, language.getMEN_STOREHOUSE());
        this.btn_confirm.setText(language.getMEN_CONFIRM());
    }

    private Panel makeStorehouse(Language language, ArrayList<Empire> empires) {
        Panel tabStorehouse = new Panel(new BorderLayout());
        Panel panelStorehouse = new Panel(new GridLayout(24, empires.size(), 0, 0));
        this.allResourceTextFields = new HashMap(22);
        this.addStorehouseHead(panelStorehouse, empires);
        this.addStorehouseBody(panelStorehouse, empires);
        tabStorehouse.add((Component)panelStorehouse, "North");
        this.btn_confirm = new JButton(language.getMEN_CONFIRM());
        this.btn_confirm.addActionListener(this);
        tabStorehouse.add((Component)this.btn_confirm, "South");
        return tabStorehouse;
    }

    private void addStorehouseHead(Panel panel, ArrayList<Empire> empires) {
        panel.add(new JLabel());
        for (Empire empire : empires) {
            panel.add(new JLabel(empire.getName()));
        }
    }

    private void addStorehouseBody(Panel panel, ArrayList<Empire> empires) {
        this.addStorehouseMoneyLine(panel, empires);
        this.addStorehouseEmptyLine(panel, empires.size());
        this.addStorehouseResourceLines(panel, empires);
    }

    private void addStorehouseMoneyLine(Panel panel, ArrayList<Empire> empires) {
        JLabel lbl_money = new JLabel(Language.getMoneySymbol());
        lbl_money.setHorizontalAlignment(0);
        int countColumn = empires.size();
        panel.add(lbl_money);
        ArrayList<JFormattedTextField> textfieldsOfMoney = new ArrayList<JFormattedTextField>(countColumn);
        for (Empire empire : empires) {
            JFormattedTextField textfield = new JFormattedTextField(numberFormatterMoney);
            textfield.setValue(empire.getMoney());
            textfield.setHorizontalAlignment(4);
            panel.add(textfield);
            textfieldsOfMoney.add(textfield);
        }
        this.allResourceTextFields.put(Enums.Resource.MONEY, textfieldsOfMoney);
    }

    private void addStorehouseEmptyLine(Panel panel, int countColumns) {
        panel.add(new JLabel());
        int i = 0;
        while (i < countColumns) {
            panel.add(new JLabel());
            ++i;
        }
    }

    private void addStorehouseResourceLines(Panel panel, ArrayList<Empire> empires) {
        for (Enums.Resource resource : Enums.resourceList) {
            if (!resource.isInStorehouse()) continue;
            ArrayList<JFormattedTextField> textfieldsOfResource = new ArrayList<JFormattedTextField>(empires.size());
            this.addStorehouseResourceLine(panel, empires, textfieldsOfResource, resource);
            this.allResourceTextFields.put(resource, textfieldsOfResource);
        }
    }

    private void addStorehouseResourceLine(Panel panel, ArrayList<Empire> empires, ArrayList<JFormattedTextField> textFields, Enums.Resource resource) {
        ImageIcon icon = new ImageIcon(Main.getResImage(resource));
        JLabel lbl_icon = new JLabel(icon);
        lbl_icon.setHorizontalAlignment(0);
        panel.add(lbl_icon);
        for (Empire empire : empires) {
            JFormattedTextField textfield = new JFormattedTextField(numberFormatterResource);
            textfield.setValue(empire.getStorehouse().getNumberOf(resource));
            textfield.setHorizontalAlignment(4);
            textFields.add(textfield);
            panel.add(textfield);
        }
    }

    private static NumberFormatter createNumberFormatter(int minValue, int maxValue) {
        NumberFormat format = NumberFormat.getInstance();
        NumberFormatter formatter = new NumberFormatter(format);
        formatter.setValueClass(Integer.class);
        formatter.setMinimum(Integer.valueOf(minValue));
        formatter.setMaximum(Integer.valueOf(maxValue));
        formatter.setAllowsInvalid(false);
        formatter.setCommitsOnValidEdit(true);
        return formatter;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.btn_confirm) {
            this.setResourceToEmpires(Enums.Resource.MONEY);
            Enums.Resource[] resourceArray = Enums.Resource.values();
            int n = resourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                Enums.Resource resource = resourceArray[n2];
                if (resource.isInStorehouse()) {
                    this.setResourceToEmpires(resource);
                }
                ++n2;
            }
        }
    }

    private void setResourceToEmpires(Enums.Resource resource) {
        ArrayList<JFormattedTextField> textFields = this.allResourceTextFields.get((Object)resource);
        if (textFields != null) {
            int empireIndex = 0;
            while (empireIndex < this.empiresAlive.size()) {
                Empire empire = this.empiresAlive.get(empireIndex);
                JFormattedTextField textField = textFields.get(empireIndex);
                int stock = (Integer)textField.getValue();
                if (resource == Enums.Resource.MONEY) {
                    empire.setMoney(stock);
                } else if (resource.isInStorehouse()) {
                    Goods storehouse = empire.getStorehouse();
                    storehouse.setNumberOf(resource, stock);
                }
                ++empireIndex;
            }
        } else {
            Main.log.logDebug("Frame_Empire.setResourceToEmpires(): textFields is null for " + resource.name());
        }
    }
}

