/*
 * Decompiled with CFR 0.152.
 */
package regius.mapeditorimp1;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import regius.gui.JPlusMinusField;
import regius.mapeditorimp1.Enums;
import regius.mapeditorimp1.Field;
import regius.mapeditorimp1.Fieldtypes;
import regius.mapeditorimp1.GlobalActions;
import regius.mapeditorimp1.Language;
import regius.mapeditorimp1.Main;
import regius.mapeditorimp1.Mapeditor;
import regius.mapeditorimp1.MiniMap;
import regius.mapeditorimp1.Province;
import regius.mapeditorimp1.SaveFile;
import regius.mapeditorimp1.View;

public class Frame_Field
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = -1893048893435852806L;
    private static Frame_Field instance;
    private Mapeditor me;
    private JPanel pl_south = new JPanel();
    private JRadioButton rbU1;
    private JRadioButton rbU2;
    private JRadioButton rbU3;
    private JRadioButton rbU4;
    private JRadioButton rbU5;
    private JRadioButton rbU6;
    private JRadioButton rbU7;
    private JRadioButton rbU9;
    private JRadioButton rbO1 = new JRadioButton();
    private JRadioButton rbO2 = new JRadioButton();
    private JRadioButton rbO3 = new JRadioButton();
    private JRadioButton rbO4 = new JRadioButton();
    private JRadioButton rbO5 = new JRadioButton();
    private JRadioButton rbO6 = new JRadioButton();
    private JRadioButton rbO7 = new JRadioButton();
    private JCheckBox cbR1;
    private JCheckBox cbR2;
    private JCheckBox cbR3;
    private JCheckBox cbR4;
    private JLabel astufe_lbl = new JLabel();
    private JPlusMinusField astufe_val = new JPlusMinusField(20, 20, this);
    private JCheckBox cb_railwaystation;
    private JCheckBox cb_harbour;
    private MiniMap miniMap;
    private Field field;
    private Fieldtypes.Fieldtype fieldtype;

    private Frame_Field(Mapeditor me) {
        this.me = me;
        Language language = Mapeditor.getLanguage();
        this.setTitle(language.getMEN_FIELD());
        this.setAlwaysOnTop(true);
        this.setDefaultCloseOperation(2);
        this.setIconImage(Main.getIcon());
        GlobalActions.getInstance(me).addGlobalActions((JComponent)this.getContentPane());
        this.setLayout(new BorderLayout());
        this.miniMap = new MiniMap(me, this);
        this.add((Component)this.miniMap, "North");
        this.miniMap.setVisible(true);
        ButtonGroup rgTerrainUnderlay = new ButtonGroup();
        JPanel panelTerrainUnderlay = new JPanel(new GridLayout(0, 1));
        this.rbU1 = new JRadioButton(language.getLND_PLAIN());
        this.rbU2 = new JRadioButton(language.getLND_FOREST());
        this.rbU3 = new JRadioButton(language.getLND_HILL());
        this.rbU4 = new JRadioButton(language.getLND_MOUNTAIN());
        this.rbU5 = new JRadioButton(language.getLND_SWAMP());
        this.rbU6 = new JRadioButton(language.getLND_DESERT());
        this.rbU7 = new JRadioButton(language.getLND_TUNDRA());
        this.rbU9 = new JRadioButton(language.getLND_OCEAN());
        this.initRadioButton(this.rbU1, Enums.GuiTerrainUnderlay.GRAS, rgTerrainUnderlay, panelTerrainUnderlay);
        this.initRadioButton(this.rbU2, Enums.GuiTerrainUnderlay.FOREST, rgTerrainUnderlay, panelTerrainUnderlay);
        this.initRadioButton(this.rbU3, Enums.GuiTerrainUnderlay.HILL, rgTerrainUnderlay, panelTerrainUnderlay);
        this.initRadioButton(this.rbU4, Enums.GuiTerrainUnderlay.MOUNTAIN, rgTerrainUnderlay, panelTerrainUnderlay);
        this.initRadioButton(this.rbU5, Enums.GuiTerrainUnderlay.SWAMP, rgTerrainUnderlay, panelTerrainUnderlay);
        this.initRadioButton(this.rbU6, Enums.GuiTerrainUnderlay.DESERT, rgTerrainUnderlay, panelTerrainUnderlay);
        this.initRadioButton(this.rbU7, Enums.GuiTerrainUnderlay.TUNDRA, rgTerrainUnderlay, panelTerrainUnderlay);
        this.initRadioButton(this.rbU9, Enums.GuiTerrainUnderlay.OCEAN, rgTerrainUnderlay, panelTerrainUnderlay);
        this.add((Component)panelTerrainUnderlay, "West");
        JPanel panelTerrainOverlay = new JPanel(new GridLayout(0, 1));
        ButtonGroup rgTerrainOverlay = new ButtonGroup();
        this.initRadioButton(this.rbO1, Enums.GuiTerrainOverlay.RB1, rgTerrainOverlay, panelTerrainOverlay);
        this.initRadioButton(this.rbO2, Enums.GuiTerrainOverlay.RB2, rgTerrainOverlay, panelTerrainOverlay);
        this.initRadioButton(this.rbO3, Enums.GuiTerrainOverlay.RB3, rgTerrainOverlay, panelTerrainOverlay);
        this.initRadioButton(this.rbO4, Enums.GuiTerrainOverlay.RB4, rgTerrainOverlay, panelTerrainOverlay);
        this.initRadioButton(this.rbO5, Enums.GuiTerrainOverlay.RB5, rgTerrainOverlay, panelTerrainOverlay);
        this.initRadioButton(this.rbO6, Enums.GuiTerrainOverlay.RB6, rgTerrainOverlay, panelTerrainOverlay);
        this.initRadioButton(this.rbO7, Enums.GuiTerrainOverlay.RB7, rgTerrainOverlay, panelTerrainOverlay);
        this.cbR1 = new JCheckBox(language.getResourceName(Enums.Resource.COAL__));
        this.cbR2 = new JCheckBox(language.getResourceName(Enums.Resource.IRON__));
        this.cbR3 = new JCheckBox(language.getResourceName(Enums.Resource.GOLD__));
        this.cbR4 = new JCheckBox(language.getResourceName(Enums.Resource.GEMS__));
        this.initCheckBox(this.cbR1, Enums.GuiTerrainOverlayMines.allMines.actionCommand, panelTerrainOverlay);
        this.initCheckBox(this.cbR2, Enums.GuiTerrainOverlayMines.allMines.actionCommand, panelTerrainOverlay);
        this.initCheckBox(this.cbR3, Enums.GuiTerrainOverlayMines.allMines.actionCommand, panelTerrainOverlay);
        this.initCheckBox(this.cbR4, Enums.GuiTerrainOverlayMines.allMines.actionCommand, panelTerrainOverlay);
        this.add((Component)panelTerrainOverlay, "Center");
        this.cb_railwaystation = new JCheckBox(language.getBUILDING_RAILWAY_STATION());
        this.cb_harbour = new JCheckBox(language.getBUILDING_PORT());
        this.pl_south.setLayout(new GridLayout(2, 2));
        this.astufe_lbl.setText(language.getBUILDING_EXTENTION());
        this.astufe_val.setValue(0);
        this.pl_south.add(this.astufe_lbl);
        this.pl_south.add(this.astufe_val);
        this.cb_harbour.addActionListener(this);
        this.pl_south.add(this.cb_harbour);
        this.cb_railwaystation.addActionListener(this);
        this.pl_south.add(this.cb_railwaystation);
        this.add((Component)this.pl_south, "South");
        this.pack();
        this.setSize((int)this.miniMap.getPreferredSize().getWidth(), this.getHeight());
    }

    private void initRadioButton(JRadioButton radioButton, Enums.ActionCommandEnum actionCommand, ButtonGroup radioGroup, JPanel panelToPlace) {
        radioButton.setActionCommand(actionCommand.getActionCommand());
        radioButton.addActionListener(this);
        radioGroup.add(radioButton);
        panelToPlace.add(radioButton);
    }

    private void initCheckBox(JCheckBox checkBox, String actionCommand, JPanel panelToPlace) {
        checkBox.setActionCommand(actionCommand);
        checkBox.addActionListener(this);
        panelToPlace.add(checkBox);
    }

    public static synchronized void exit() {
        if (instance != null) {
            instance.dispose();
            instance = null;
        }
    }

    public static synchronized Frame_Field getInstance(Mapeditor me) {
        if (instance == null) {
            instance = new Frame_Field(me);
        }
        return instance;
    }

    public void refreshLanguage(Language language) {
        this.setTitle(language.getMEN_FIELD());
        this.setRadioButtons(language);
        this.rbU1.setText(language.getLND_PLAIN());
        this.rbU2.setText(language.getLND_FOREST());
        this.rbU3.setText(language.getLND_HILL());
        this.rbU4.setText(language.getLND_MOUNTAIN());
        this.rbU5.setText(language.getLND_SWAMP());
        this.rbU6.setText(language.getLND_DESERT());
        this.rbU7.setText(language.getLND_TUNDRA());
        this.rbU9.setText(language.getLND_OCEAN());
        this.cbR1.setText(language.getResourceName(Enums.Resource.COAL__));
        this.cbR2.setText(language.getResourceName(Enums.Resource.IRON__));
        this.cbR3.setText(language.getResourceName(Enums.Resource.GOLD__));
        this.cbR4.setText(language.getResourceName(Enums.Resource.GEMS__));
        this.cb_railwaystation.setText(language.getBUILDING_RAILWAY_STATION());
        this.cb_harbour.setText(language.getBUILDING_PORT());
        this.astufe_lbl.setText(language.getBUILDING_EXTENTION());
    }

    public void init(Field field) {
        if (!this.isVisible()) {
            Point p = this.me.getView().getLocationOnScreen();
            int y = p.y + this.me.getView().getHeight() - this.getHeight();
            if (y < 0) {
                y = 0;
            }
            this.setLocation(p.x, y);
        }
        this.field = field;
        this.fieldtype = SaveFile.getFieldtypes().getFieldtype(field);
        this.initValues(false);
    }

    private void initValues(boolean repaintAll) {
        this.setRadioButtons(Mapeditor.getLanguage());
        this.setCB_Ausbaustufe();
        this.setCB_Bahnhof();
        this.setCB_Hafen();
        View view = this.me.getView();
        this.miniMap.setShowProvinceName(view.isShowPName());
        this.miniMap.setShowNationalBorder(view.isShowNBorder());
        this.miniMap.setShowProvinceBorder(view.isShowPBorder());
        if (repaintAll) {
            this.me.repaintAll();
        } else {
            this.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean repaintAll;
        block31: {
            String command;
            block34: {
                block33: {
                    block32: {
                        block30: {
                            command = e.getActionCommand();
                            repaintAll = false;
                            Main.log.logDebug("Test IFrame_Field.actionPerformed: " + command);
                            if (e.getSource() != this.astufe_val.getPlus()) break block30;
                            this.field.nextExpansion();
                            repaintAll = true;
                            break block31;
                        }
                        if (e.getSource() != this.astufe_val.getMinus()) break block32;
                        this.field.previousExpansion();
                        repaintAll = true;
                        break block31;
                    }
                    if (e.getSource() != this.cb_harbour) break block33;
                    Province provinz = this.field.getProvince();
                    boolean anschluss = this.cb_harbour.isSelected() || this.cb_railwaystation.isSelected();
                    Field[] fieldArray = this.field.getFieldsSurrounding();
                    int n = fieldArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Field f = fieldArray[n2];
                        if (f.isCity()) {
                            f.getProvince().setAnschlussCity(anschluss, this.me.getSavefile().getTurn());
                        }
                        ++n2;
                    }
                    if (this.field.isCity()) {
                        provinz.setAnschlussCity(anschluss, this.me.getSavefile().getTurn());
                    }
                    this.field.setHabor(this.cb_harbour.isSelected());
                    provinz.getEmpire().modifyStation(this.me.getView().getMarkedX() + Main.map_fieldsX * this.me.getView().getMarkedY(), this.cb_harbour.isSelected(), this.cb_railwaystation.isSelected());
                    repaintAll = true;
                    break block31;
                }
                if (e.getSource() != this.cb_railwaystation) break block34;
                Province provinz = this.field.getProvince();
                boolean anschluss = this.cb_harbour.isSelected() || this.cb_railwaystation.isSelected();
                int transportNr = 14;
                Field[] fieldArray = this.field.getFieldsSurrounding();
                int n = fieldArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Field f = fieldArray[n3];
                    if (!f.isOcean()) {
                        if (f.isCity()) {
                            f.getProvince().setAnschlussCity(anschluss, this.me.getSavefile().getTurn());
                        }
                        if (f.getTransportId() == 0) {
                            f.setTransportId((byte)14);
                        }
                    }
                    ++n3;
                }
                this.field.setTransportId((byte)14);
                if (this.field.isCity()) {
                    provinz.setAnschlussCity(anschluss, this.me.getSavefile().getTurn());
                }
                this.field.setRailwayStation(this.cb_railwaystation.isSelected());
                provinz.getEmpire().modifyStation(this.me.getView().getMarkedX() + Main.map_fieldsX * this.me.getView().getMarkedY(), this.cb_harbour.isSelected(), this.cb_railwaystation.isSelected());
                repaintAll = true;
                break block31;
            }
            if (!command.substring(0, 1).equalsIgnoreCase("_")) break block31;
            String radioButtonName = command.substring(2);
            switch (command.substring(0, 2)) {
                case "_B": {
                    Enums.GuiTerrainUnderlay actionTerrainUnderlay;
                    try {
                        actionTerrainUnderlay = Enums.GuiTerrainUnderlay.valueOf(radioButtonName);
                    }
                    catch (IllegalArgumentException iae) {
                        Main.log.logDebug("Search Enum, but command wrong: " + command, iae);
                        return;
                    }
                    if (actionTerrainUnderlay == null) break;
                    this.fieldtype = SaveFile.getFieldtypes().getFieldtype(actionTerrainUnderlay, Enums.GuiTerrainOverlay.RB1);
                    break;
                }
                case "_U": {
                    Enums.GuiTerrainOverlay actionTerrainOverlay;
                    try {
                        actionTerrainOverlay = Enums.GuiTerrainOverlay.valueOf(radioButtonName);
                    }
                    catch (IllegalArgumentException iae) {
                        Main.log.logDebug("Search Enum, but command wrong: " + command, iae);
                        return;
                    }
                    if (this.field.isOceanAndNotShore()) {
                        this.fieldtype = SaveFile.getFieldtypes().getFieldtype(this.fieldtype.guiTerrainUnderlay, actionTerrainOverlay, Enums.Resource._EMPTY, Enums.Resource._EMPTY);
                        break;
                    }
                    this.fieldtype = SaveFile.getFieldtypes().getFieldtype(this.fieldtype.guiTerrainUnderlay, actionTerrainOverlay);
                    break;
                }
                case "_C": {
                    Enums.GuiTerrainOverlay guiTerrainOverlay;
                    switch (this.fieldtype.terrain_under) {
                        case HILL: {
                            guiTerrainOverlay = Enums.GuiTerrainOverlay.RB1;
                            break;
                        }
                        case MOUNTAIN: {
                            guiTerrainOverlay = this.fieldtype.guiTerrainOverlay;
                            break;
                        }
                        default: {
                            Object guiTerrainOverlay2 = null;
                            Main.log.logDebug("actionTerrainUnderlay.terrainUnderlay is null in 'case GuiTerrainOverlayMines.prefix'");
                            return;
                        }
                    }
                    ArrayList<Enums.Resource> selectedResources = this.getSelectedResources();
                    this.fieldtype = SaveFile.getFieldtypes().getFieldtype(this.fieldtype.guiTerrainUnderlay, guiTerrainOverlay, selectedResources.get(0), selectedResources.get(1));
                    break;
                }
            }
            this.field.changeFieldByFieldType(this.fieldtype);
            repaintAll = true;
        }
        this.initValues(repaintAll);
    }

    private ArrayList<Enums.Resource> getSelectedResources() {
        ArrayList<Enums.Resource> selectedResources = new ArrayList<Enums.Resource>(2);
        if (this.cbR1.isSelected()) {
            selectedResources.add(Enums.Resource.COAL__);
        }
        if (this.cbR2.isSelected()) {
            selectedResources.add(Enums.Resource.IRON__);
        }
        if (this.cbR3.isSelected() && selectedResources.size() < 2) {
            selectedResources.add(Enums.Resource.GOLD__);
        }
        if (this.cbR4.isSelected() && selectedResources.size() < 2) {
            selectedResources.add(Enums.Resource.GEMS__);
        }
        int i = selectedResources.size();
        while (i < 2) {
            selectedResources.add(Enums.Resource._EMPTY);
            ++i;
        }
        return selectedResources;
    }

    private void setCB_Ausbaustufe() {
        if (this.fieldtype != null) {
            this.astufe_val.setComponentsEditable(true);
            this.astufe_val.setLimits(0, this.fieldtype.maxExpansion.value);
            this.astufe_val.setValue(this.field.getExpansion().value);
        } else {
            this.astufe_val.setComponentsEditable(false);
        }
    }

    private void setCB_Bahnhof() {
        if (this.field != null && !this.field.isOcean() && this.field.getProvince().getEmpire() != null) {
            this.cb_railwaystation.setEnabled(true);
            this.cb_railwaystation.setSelected(this.field.isRailwayStation());
        } else {
            this.cb_railwaystation.setEnabled(false);
        }
    }

    private void setCB_Hafen() {
        if (this.field != null) {
            Province tmpProvinz = this.field.getProvince();
            if (tmpProvinz != null && tmpProvinz.getEmpire() != null) {
                boolean isHaborPossible = false;
                if (this.field.isRiver()) {
                    isHaborPossible = true;
                } else if (!this.field.isOcean()) {
                    Field[] fieldsSurrounding = this.field.getFieldsSurrounding();
                    int i = 0;
                    while (i < fieldsSurrounding.length && !isHaborPossible) {
                        if (fieldsSurrounding[i] != null && fieldsSurrounding[i].isOcean()) {
                            isHaborPossible = true;
                        }
                        ++i;
                    }
                }
                this.cb_harbour.setSelected(this.field.isHabor());
                this.cb_harbour.setEnabled(isHaborPossible);
            } else {
                this.cb_harbour.setEnabled(false);
            }
        }
    }

    private void setRadioButtons(Language language) {
        if (this.fieldtype != null) {
            switch (this.fieldtype.guiTerrainUnderlay) {
                case GRAS: {
                    this.rbU1.setSelected(true);
                    this.rbU1.setEnabled(true);
                    this.rbU2.setEnabled(true);
                    this.rbU3.setEnabled(true);
                    this.rbU4.setEnabled(true);
                    this.rbU5.setEnabled(true);
                    this.rbU6.setEnabled(true);
                    this.rbU7.setEnabled(true);
                    this.rbU9.setEnabled(false);
                    this.setRadioButtonsTerrainOverlay(7, language.getLND_NOTHING(), language.getLND_DRY_PLAIN(), language.getLND_FIELD(), language.getLND_FRUIT(), language.getLND_CATTLE(), language.getLND_COTTON(), language.getLND_HORSES(), false);
                    this.setCheckBoxMineOff();
                    break;
                }
                case FOREST: {
                    this.rbU2.setSelected(true);
                    this.rbU1.setEnabled(true);
                    this.rbU2.setEnabled(true);
                    this.rbU3.setEnabled(true);
                    this.rbU4.setEnabled(true);
                    this.rbU5.setEnabled(true);
                    this.rbU6.setEnabled(true);
                    this.rbU7.setEnabled(true);
                    this.rbU9.setEnabled(false);
                    this.setRadioButtonsTerrainOverlay(2, language.getLND_FOREST(), language.getLND_SCRUB_FOREST(), "", "", "", "", "", false);
                    this.setCheckBoxMineOff();
                    break;
                }
                case HILL: {
                    this.rbU3.setSelected(true);
                    this.rbU1.setEnabled(true);
                    this.rbU2.setEnabled(true);
                    this.rbU3.setEnabled(true);
                    this.rbU4.setEnabled(true);
                    this.rbU5.setEnabled(true);
                    this.rbU6.setEnabled(true);
                    this.rbU7.setEnabled(true);
                    this.rbU9.setEnabled(false);
                    this.setRadioButtonsTerrainOverlay(2, language.getLND_NOTHING(), language.getLND_PASTURE_HILL(), "", "", "", "", "", true);
                    this.setCheckBoxMine(true, this.field.getResource1(), this.field.getResource2());
                    break;
                }
                case MOUNTAIN: {
                    this.rbU4.setSelected(true);
                    this.rbU1.setEnabled(true);
                    this.rbU2.setEnabled(true);
                    this.rbU3.setEnabled(true);
                    this.rbU4.setEnabled(true);
                    this.rbU5.setEnabled(true);
                    this.rbU6.setEnabled(true);
                    this.rbU7.setEnabled(true);
                    this.rbU9.setEnabled(false);
                    this.setRadioButtonsTerrainOverlay(2, String.valueOf(language.getLND_MOUNTAIN()) + " 1", String.valueOf(language.getLND_MOUNTAIN()) + " 2", "", "", "", "", "", true);
                    this.setCheckBoxMine(true, this.field.getResource1(), this.field.getResource2());
                    break;
                }
                case SWAMP: {
                    this.rbU5.setSelected(true);
                    this.rbU1.setEnabled(true);
                    this.rbU2.setEnabled(true);
                    this.rbU3.setEnabled(true);
                    this.rbU4.setEnabled(true);
                    this.rbU5.setEnabled(true);
                    this.rbU6.setEnabled(true);
                    this.rbU7.setEnabled(true);
                    this.rbU9.setEnabled(false);
                    this.setRadioButtonsTerrainOverlay(2, language.getLND_NOTHING(), language.getLND_OIL_WELL(), "", "", "", "", "", false);
                    this.setCheckBoxMineOff();
                    break;
                }
                case DESERT: {
                    this.rbU6.setSelected(true);
                    this.rbU1.setEnabled(true);
                    this.rbU2.setEnabled(true);
                    this.rbU3.setEnabled(true);
                    this.rbU4.setEnabled(true);
                    this.rbU5.setEnabled(true);
                    this.rbU6.setEnabled(true);
                    this.rbU7.setEnabled(true);
                    this.rbU9.setEnabled(false);
                    this.setRadioButtonsTerrainOverlay(2, language.getLND_NOTHING(), language.getLND_OIL_WELL(), "", "", "", "", "", false);
                    this.setCheckBoxMineOff();
                    break;
                }
                case TUNDRA: {
                    this.rbU7.setSelected(true);
                    this.rbU1.setEnabled(true);
                    this.rbU2.setEnabled(true);
                    this.rbU3.setEnabled(true);
                    this.rbU4.setEnabled(true);
                    this.rbU5.setEnabled(true);
                    this.rbU6.setEnabled(true);
                    this.rbU7.setEnabled(true);
                    this.rbU9.setEnabled(false);
                    this.setRadioButtonsTerrainOverlay(2, language.getLND_NOTHING(), language.getLND_OIL_WELL(), "", "", "", "", "", false);
                    this.setCheckBoxMineOff();
                    break;
                }
                case OCEAN: {
                    this.rbU9.setSelected(true);
                    this.rbU1.setEnabled(false);
                    this.rbU2.setEnabled(false);
                    this.rbU3.setEnabled(false);
                    this.rbU4.setEnabled(false);
                    this.rbU5.setEnabled(false);
                    this.rbU6.setEnabled(false);
                    this.rbU7.setEnabled(false);
                    this.rbU9.setEnabled(true);
                    if (this.field.isOceanAndShore()) {
                        this.setRadioButtonsTerrainOverlay(2, language.getLND_NOTHING(), language.getLND_FISH(), "", "", "", "", "", false);
                    } else {
                        this.setRadioButtonsTerrainOverlay(5, language.getLND_NOTHING(), language.getLND_SANDBAR(), language.getLND_ISLAND_SMALL(), language.getLND_ISLAND_LARGE(), language.getLND_ISLAND_GROUP(), "", "", false);
                    }
                    this.setCheckBoxMineOff();
                    break;
                }
                default: {
                    this.rbU1.setEnabled(false);
                    this.rbU2.setEnabled(false);
                    this.rbU3.setEnabled(false);
                    this.rbU4.setEnabled(false);
                    this.rbU5.setEnabled(false);
                    this.rbU6.setEnabled(false);
                    this.rbU7.setEnabled(false);
                    this.rbU9.setEnabled(false);
                    this.setRadioButtonsTerrainOverlay(1, language.getMIS_ERROR(), "", "", "", "", "", "", false);
                    this.setCheckBoxMineOff();
                }
            }
            switch (this.fieldtype.guiTerrainOverlay) {
                case RB1: {
                    this.rbO1.setSelected(true);
                    break;
                }
                case RB2: {
                    this.rbO2.setSelected(true);
                    break;
                }
                case RB3: {
                    this.rbO3.setSelected(true);
                    break;
                }
                case RB4: {
                    this.rbO4.setSelected(true);
                    break;
                }
                case RB5: {
                    this.rbO5.setSelected(true);
                    break;
                }
                case RB6: {
                    this.rbO6.setSelected(true);
                    break;
                }
                case RB7: {
                    this.rbO7.setSelected(true);
                }
            }
        }
    }

    private void setRadioButtonsTerrainOverlay(int numberOfVariations, String textRB1, String textRB2, String textRB3, String textRB4, String textRB5, String textRB6, String textRB7, boolean canHaveMines) {
        this.setRadioButtonsTerrainOverlayPerRadioButton(this.rbO1, 1, numberOfVariations, textRB1);
        this.setRadioButtonsTerrainOverlayPerRadioButton(this.rbO2, 2, numberOfVariations, textRB2);
        this.setRadioButtonsTerrainOverlayPerRadioButton(this.rbO3, 3, numberOfVariations, textRB3);
        this.setRadioButtonsTerrainOverlayPerRadioButton(this.rbO4, 4, numberOfVariations, textRB4);
        this.setRadioButtonsTerrainOverlayPerRadioButton(this.rbO5, 5, numberOfVariations, textRB5);
        this.setRadioButtonsTerrainOverlayPerRadioButton(this.rbO6, 6, numberOfVariations, textRB6);
        this.setRadioButtonsTerrainOverlayPerRadioButton(this.rbO7, 7, numberOfVariations, textRB7);
    }

    private void setRadioButtonsTerrainOverlayPerRadioButton(JRadioButton rbTerrainOverlay, int number, int numberOfVariations, String textRB) {
        if (number <= numberOfVariations) {
            rbTerrainOverlay.setText(textRB);
            rbTerrainOverlay.setVisible(true);
        } else {
            rbTerrainOverlay.setVisible(false);
        }
    }

    private void setCheckBoxMineOff() {
        this.setCheckBoxMine(false, null, null);
    }

    private void setCheckBoxMine(boolean canHaveMines, Enums.Resource resource1, Enums.Resource resource2) {
        this.cbR1.setVisible(canHaveMines);
        this.cbR2.setVisible(canHaveMines);
        this.cbR3.setVisible(canHaveMines);
        this.cbR4.setVisible(canHaveMines);
        this.cbR1.setSelected(false);
        this.cbR2.setSelected(false);
        this.cbR3.setSelected(false);
        this.cbR4.setSelected(false);
        if (canHaveMines) {
            switch (resource1) {
                case COAL__: {
                    this.cbR1.setSelected(true);
                    break;
                }
                case IRON__: {
                    this.cbR2.setSelected(true);
                    break;
                }
                case GOLD__: {
                    this.cbR3.setSelected(true);
                    break;
                }
                case GEMS__: {
                    this.cbR4.setSelected(true);
                    break;
                }
            }
            switch (resource2) {
                case IRON__: {
                    this.cbR2.setSelected(true);
                    break;
                }
                case GOLD__: {
                    this.cbR3.setSelected(true);
                    break;
                }
                case GEMS__: {
                    this.cbR4.setSelected(true);
                    break;
                }
            }
        }
    }

    public void toggleRail(int c) {
        Fieldtypes.toggleRail(this.field, c);
    }

    public final Field getField() {
        return this.field;
    }

    public void setShowProvinceName(boolean showProvinceName) {
        this.miniMap.setShowProvinceName(showProvinceName);
    }

    public void setShowProvinceBorder(boolean showProvinceBorder) {
        this.miniMap.setShowProvinceBorder(showProvinceBorder);
    }

    public void setShowNationalBorder(boolean shwoNationalBorder) {
        this.miniMap.setShowNationalBorder(shwoNationalBorder);
    }
}

