/*
 * Decompiled with CFR 0.152.
 */
package regius.mapeditorimp1;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import regius.gui.JPlusMinusField;
import regius.mapeditorimp1.Field;
import regius.mapeditorimp1.GlobalActions;
import regius.mapeditorimp1.Language;
import regius.mapeditorimp1.Main;
import regius.mapeditorimp1.Mapeditor;
import regius.mapeditorimp1.Province;

public class Frame_Province
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1881016477552548970L;
    private static Frame_Province instance;
    private Mapeditor me;
    private Province provinz;
    private JTextField tf_provinceName;
    private JButton btn_changeName;
    private JLabel lbl_fortress;
    private JPlusMinusField pm_fortress;
    InputMap im;
    ActionMap am;
    private Container container;
    private GridBagLayout gbLayout;
    private GridBagConstraints gbConstraints;

    private Frame_Province(Mapeditor me) {
        this.me = me;
        Language language = Mapeditor.getLanguage();
        this.setTitle(language.getMEN_PROVINCE());
        this.setAlwaysOnTop(true);
        this.setDefaultCloseOperation(2);
        this.setIconImage(Main.getIcon());
        this.tf_provinceName = new JTextField();
        this.btn_changeName = new JButton(language.getMIS_BTN_OK());
        this.lbl_fortress = new JLabel(language.getBUILDING_FORTRESS());
        this.pm_fortress = new JPlusMinusField(20, 20, this, 0, 3);
        this.tf_provinceName.setColumns(10);
        this.btn_changeName.addActionListener(this);
        this.btn_changeName.setPreferredSize(new Dimension(20, 20));
        this.pm_fortress.setValue(0);
        this.container = this.getContentPane();
        this.gbLayout = new GridBagLayout();
        this.container.setLayout(this.gbLayout);
        GlobalActions.getInstance(me).addGlobalActions((JComponent)this.getContentPane());
        this.gbConstraints = new GridBagConstraints();
        this.gbConstraints.fill = 2;
        this.gbConstraints.insets = new Insets(1, 1, 1, 1);
        this.addComponent(0, 0, 1, 1, this.tf_provinceName);
        this.addComponent(0, 1, 1, 1, this.btn_changeName);
        this.addComponent(1, 0, 1, 1, this.lbl_fortress);
        this.addComponent(1, 1, 1, 1, this.pm_fortress);
        this.pack();
    }

    private void addComponent(int row, int column, int width, int height, Component c) {
        this.gbConstraints.gridx = column;
        this.gbConstraints.gridy = row;
        this.gbConstraints.gridwidth = width;
        this.gbConstraints.gridheight = height;
        this.gbLayout.setConstraints(c, this.gbConstraints);
        this.container.add(c);
    }

    public static synchronized void exit() {
        if (instance != null) {
            instance.dispose();
            instance = null;
        }
    }

    public static synchronized Frame_Province getInstance(Mapeditor me) {
        if (instance == null) {
            instance = new Frame_Province(me);
        }
        return instance;
    }

    public void init(Field feld) {
        this.init(feld.getProvince());
    }

    private void init(Province provinz) {
        this.provinz = provinz;
        if (!this.isVisible()) {
            Point p = this.me.getView().getLocationOnScreen();
            int x = p.x + this.me.getView().getWidth() - this.getWidth();
            int y = p.y;
            if (x < 0) {
                x = 0;
            }
            this.setLocation(x, y);
        }
        if (provinz == null) {
            this.setComponendsEditable(false);
            this.tf_provinceName.setText(Mapeditor.getLanguage().getLND_OCEAN());
            this.pm_fortress.setValue(0);
        } else {
            this.setComponendsEditable(true);
            this.tf_provinceName.setText(provinz.getName());
            this.pm_fortress.setValue(provinz.getStufe_festung());
            this.requestFocus();
        }
    }

    private void setComponendsEditable(boolean editable) {
        this.tf_provinceName.setEditable(editable);
        this.btn_changeName.setEnabled(editable);
        this.pm_fortress.setComponentsEditable(editable);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        int fs_value;
        if (ae.getSource() == this.pm_fortress.getPlus()) {
            fs_value = this.pm_fortress.getValue() + 1;
            this.provinz.setStufeFestung(fs_value);
            this.pm_fortress.setValue(fs_value);
        }
        if (ae.getSource() == this.pm_fortress.getMinus()) {
            fs_value = this.pm_fortress.getValue() - 1;
            this.provinz.setStufeFestung(fs_value);
            this.pm_fortress.setValue(fs_value);
        }
        if (ae.getSource() == this.btn_changeName) {
            this.provinz.setName(this.tf_provinceName.getText());
        }
        this.me.repaintAll();
    }

    public void refreshLanguage(Language language) {
        this.setTitle(language.getMEN_PROVINCE());
        this.btn_changeName.setText(language.getMIS_BTN_OK());
        this.lbl_fortress.setText(language.getBUILDING_FORTRESS());
        if (this.provinz == null) {
            this.tf_provinceName.setText(language.getLND_OCEAN());
        }
    }
}

