/*
 * Decompiled with CFR 0.152.
 */
package regius.mapeditorimp1;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JTextField;
import regius.mapeditorimp1.Language;
import regius.mapeditorimp1.Main;
import regius.mapeditorimp1.Mapeditor;

public class Frame_Turn
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = -4655892198763343153L;
    private static Frame_Turn instance;
    private Mapeditor me;
    private int year;
    private int season;
    private JTextField tf_year = new JTextField(4);
    private JComboBox<String> cb_season;
    private JButton btn_forward = new JButton(">");
    private JButton btn_back = new JButton("<");

    private Frame_Turn(Mapeditor me) {
        this.me = me;
        Language language = Mapeditor.getLanguage();
        this.setTitle(language.getMEN_TURN());
        this.setAlwaysOnTop(true);
        this.setDefaultCloseOperation(2);
        this.setLayout(new BorderLayout());
        this.setIconImage(Main.getIcon());
        this.tf_year.setVisible(true);
        this.tf_year.setEditable(false);
        this.tf_year.addActionListener(this);
        this.add((Component)this.tf_year, "Center");
        this.cb_season = new JComboBox();
        this.setTextSeasons(language);
        this.cb_season.addActionListener(this);
        this.add(this.cb_season, "South");
        this.btn_forward.addActionListener(this);
        this.add((Component)this.btn_forward, "East");
        this.btn_back.addActionListener(this);
        this.add((Component)this.btn_back, "West");
        this.setTurnOnDisplay(me.getSavefile().getTurn());
        this.pack();
        this.setLocationRelativeTo(me);
    }

    public static synchronized void exit() {
        if (instance != null) {
            instance.dispose();
            instance = null;
        }
    }

    public static synchronized Frame_Turn getInstance(Mapeditor me) {
        if (instance == null) {
            instance = new Frame_Turn(me);
        }
        return instance;
    }

    public void setTurn(int turn) {
        if (turn < 0) {
            turn = 0;
        }
        this.setTurnOnDisplay(turn);
        this.me.getSavefile().setTurn(turn);
    }

    private void setTurnOnDisplay(int turn) {
        this.year = turn / 4 + 1815;
        this.season = turn % 4;
        this.tf_year.setText("" + this.year);
        this.cb_season.setSelectedIndex(this.season);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.btn_forward) {
            int turn = this.me.getSavefile().getTurn() + 1;
            this.setTurn(turn);
        } else if (ae.getSource() == this.btn_back) {
            int turn = this.me.getSavefile().getTurn() - 1;
            this.setTurn(turn);
        } else if (ae.getSource() == this.cb_season) {
            int turn = (Integer.valueOf(this.tf_year.getText()) - 1815) * 4;
            this.setTurn(turn += this.cb_season.getSelectedIndex());
        }
    }

    public void refreshLanguage(Language language) {
        this.setTitle(language.getMEN_TURN());
        int selected = this.cb_season.getSelectedIndex();
        this.setTextSeasons(language);
        this.cb_season.setSelectedIndex(selected);
    }

    private void setTextSeasons(Language language) {
        boolean hasActionListener = false;
        if (this.cb_season.getActionListeners().length > 0) {
            hasActionListener = true;
            this.cb_season.removeActionListener(this);
        }
        this.cb_season.removeAllItems();
        this.cb_season.addItem(language.getMIS_WINTER());
        this.cb_season.addItem(language.getMIS_SPRING());
        this.cb_season.addItem(language.getMIS_SUMMER());
        this.cb_season.addItem(language.getMIS_FALL());
        if (hasActionListener) {
            this.cb_season.addActionListener(this);
        }
    }
}

