/*
 * Decompiled with CFR 0.152.
 */
package regius.mapeditorimp1;

import java.awt.Color;
import java.awt.Font;
import regius.mapeditorimp1.Main;

public class GraphicsConfig {
    private boolean showNationalBorder;
    private boolean showProvinceBorder;
    private boolean showProvinceName;
    private boolean showProvinceResource;
    private Font fontProvinzname;
    private Color colorProvinzname;
    private int fieldLength;

    public GraphicsConfig(boolean showProvinceName, boolean showNationalBorder, boolean showProvinceBorder, Font fontProvinzname, Color colorProvinzname, int fieldLength) {
        this.showProvinceName = showProvinceName;
        this.showProvinceResource = true;
        this.showNationalBorder = showNationalBorder;
        this.showProvinceBorder = showProvinceBorder;
        this.fontProvinzname = fontProvinzname;
        this.colorProvinzname = colorProvinzname;
        this.fieldLength = fieldLength;
    }

    public GraphicsConfig() {
        this.showProvinceName = true;
        this.showProvinceResource = true;
        this.showNationalBorder = false;
        this.showProvinceBorder = false;
        this.fontProvinzname = new Font("SansSerif", 0, 8);
        this.colorProvinzname = Color.decode("#FFFFFF");
        this.fieldLength = Main.fieldPixelMax;
    }

    public boolean setFontProvinznameSize(int size) {
        boolean changed = false;
        if (this.fontProvinzname.getSize() != size) {
            this.fontProvinzname = new Font(this.fontProvinzname.getFontName(), this.fontProvinzname.getStyle(), size);
            changed = true;
        }
        return changed;
    }

    public boolean isShowProvinceName() {
        return this.showProvinceName;
    }

    public void setShowProvinceName(boolean showProvinceName) {
        this.showProvinceName = showProvinceName;
    }

    public boolean isShowProvinceResource() {
        return this.showProvinceResource;
    }

    public void setShowProvinceResource(boolean showProvinceResource) {
        this.showProvinceResource = showProvinceResource;
    }

    public boolean isShowNationalBorder() {
        return this.showNationalBorder;
    }

    public void setShowNationalBorder(boolean showNationalBorder) {
        this.showNationalBorder = showNationalBorder;
    }

    public boolean isShowProvinceBorder() {
        return this.showProvinceBorder;
    }

    public void setShowProvinceBorder(boolean showProvinceBorder) {
        this.showProvinceBorder = showProvinceBorder;
    }

    public Font getFontProvinzname() {
        return this.fontProvinzname;
    }

    public void setFontProvinzname(Font fontProvinzname) {
        this.fontProvinzname = fontProvinzname;
    }

    public Color getColorProvinzname() {
        return this.colorProvinzname;
    }

    public void setColorProvinzname(Color colorProvinzname) {
        this.colorProvinzname = colorProvinzname;
    }

    public int getFieldLength() {
        return this.fieldLength;
    }

    public boolean setFieldLengthValidated(int fieldLength, int min, int max) {
        boolean changed = false;
        if (min > max) {
            Main.log.logWarning("Validation invalid: min=" + min + " > " + "max=" + max);
        } else {
            if (fieldLength < min) {
                fieldLength = min;
            } else if (fieldLength > max) {
                fieldLength = max;
            }
            if (this.fieldLength != fieldLength) {
                this.fieldLength = fieldLength;
                changed = true;
            }
        }
        return changed;
    }
}

