/*
 * Decompiled with CFR 0.152.
 */
package regius.mapeditorimp1;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import regius.mapeditorimp1.Enums;
import regius.mapeditorimp1.Main;
import regius.mapeditorimp1.Province;

public class GraphicsWork {
    private Graphics g;
    private GraphicsWorkType type;
    private int pixelPosX;
    private int pixelPosY;
    private String text;
    private Color color;
    private Font font;
    private Province provinz;
    private int fieldSize;

    private GraphicsWork(GraphicsWorkType type, Graphics g) {
        this.type = type;
        this.g = g;
    }

    public void paint() {
        switch (this.type) {
            case invalid: {
                break;
            }
            case Provinzname: {
                this.paintProvinceName();
                break;
            }
            case Provinzresource: {
                this.paintProvinceResources();
            }
        }
    }

    public static GraphicsWork newProvinzname(Graphics g, Color colorProvinzname, Font fontProvinzname, String text, int pixelPosX, int pixelPosY) {
        GraphicsWork gw = new GraphicsWork(GraphicsWorkType.Provinzname, g);
        gw.color = colorProvinzname;
        gw.font = fontProvinzname;
        gw.text = text;
        gw.pixelPosX = pixelPosX;
        gw.pixelPosY = pixelPosY + gw.font.getSize() / 2;
        return gw;
    }

    public static GraphicsWork newProvinzressource(Graphics g, Color colorResourceNumber, Font fontResourceNumber, int pixelPosX, int pixelPosY, int fieldSize, Province provinz) {
        GraphicsWork gw = new GraphicsWork(GraphicsWorkType.Provinzresource, g);
        gw.color = colorResourceNumber;
        gw.font = fontResourceNumber;
        gw.pixelPosX = pixelPosX;
        gw.pixelPosY = pixelPosY;
        gw.fieldSize = fieldSize;
        gw.provinz = provinz;
        return gw;
    }

    private void paintProvinceName() {
        this.g.setFont(this.font);
        this.g.setColor(this.color);
        this.g.drawString(this.text, this.pixelPosX, this.pixelPosY);
    }

    private void paintProvinceResources() {
        this.paintProvinceResource(this.provinz.getResTextil(), Main.getResImage(Enums.Resource.Textil));
        this.paintProvinceResource(this.provinz.getResClothes(), Main.getResImage(Enums.Resource.Clothes));
        this.paintProvinceResource(this.provinz.getResLumber(), Main.getResImage(Enums.Resource.Lumber));
        this.paintProvinceResource(this.provinz.getResFurniture(), Main.getResImage(Enums.Resource.Furniture));
        this.paintProvinceResource(this.provinz.getResSteel(), Main.getResImage(Enums.Resource.Steel));
        this.paintProvinceResource(this.provinz.getResTools(), Main.getResImage(Enums.Resource.Tools));
        this.paintProvinceResource(this.provinz.getResFuel(), Main.getResImage(Enums.Resource.Fuel));
    }

    private void paintProvinceResource(int cntRes, BufferedImage bi) {
        if (cntRes > 0) {
            int imageWidth = bi.getWidth();
            int imageHeight = bi.getHeight();
            int imageZoomedWidth = imageWidth * this.fieldSize / Main.fieldPixelMax;
            int imageZoomedHeight = imageHeight * this.fieldSize / Main.fieldPixelMax;
            int zoomedPosXNumber = imageZoomedWidth - 1;
            BufferedImage zoomedImage = new BufferedImage(imageZoomedWidth, imageZoomedHeight, 2);
            Graphics2D gRessImage = zoomedImage.createGraphics();
            gRessImage.drawImage(bi, 0, 0, imageZoomedWidth, imageZoomedHeight, 0, 0, imageWidth, imageHeight, null);
            this.g.drawImage(zoomedImage, this.pixelPosX, this.pixelPosY, null);
            if (cntRes > 1) {
                this.g.setFont(this.font);
                this.g.setColor(this.color);
                this.g.drawString(String.valueOf(cntRes), this.pixelPosX + zoomedPosXNumber, this.pixelPosY + imageZoomedHeight / 2);
            }
            this.pixelPosY += imageZoomedHeight - 1;
        }
    }

    private static enum GraphicsWorkType {
        invalid,
        Provinzname,
        Provinzresource;

    }
}

