/*
 * Decompiled with CFR 0.152.
 */
package regius.mapeditorimp1;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import regius.mapeditorimp1.Field;
import regius.mapeditorimp1.GraphicsConfig;
import regius.mapeditorimp1.GraphicsWork;
import regius.mapeditorimp1.Main;
import regius.mapeditorimp1.Province;
import regius.tools.Convert;

public class GraphicsWorker {
    Graphics g;
    GraphicsConfig gc;
    ImageObserver imageObserver;
    private ArrayList<GraphicsWork> gwList = new ArrayList();

    public GraphicsWorker(Graphics g, GraphicsConfig gc, ImageObserver imageObserver) {
        this.g = g;
        this.gc = gc;
        this.imageObserver = imageObserver;
    }

    public void finish() {
        for (GraphicsWork gw : this.gwList) {
            gw.paint();
        }
        this.gwList.clear();
    }

    public void doPaintField(Field field, int x, int y) {
        if (field != null) {
            int fieldLength = this.gc.getFieldLength();
            this.g.drawImage(field.getBild(), x, y, fieldLength, fieldLength, this.imageObserver);
            if (this.gc.isShowProvinceBorder() && !field.isOcean()) {
                this.doPaintProvinceBorder(field, x, y, fieldLength);
            }
            if (this.gc.isShowNationalBorder() && !field.isOcean()) {
                this.doPaintNationalBorder(field, x, y, fieldLength);
            }
            if (this.gc.isShowProvinceResource() && field.isCity()) {
                this.gwList.add(GraphicsWork.newProvinzressource(this.g, this.gc.getColorProvinzname(), this.gc.getFontProvinzname(), x + fieldLength - fieldLength / 6, y, fieldLength, field.getProvince()));
            }
            if (this.gc.isShowProvinceName() && field.isCity()) {
                this.gwList.add(GraphicsWork.newProvinzname(this.g, this.gc.getColorProvinzname(), this.gc.getFontProvinzname(), field.getProvince().getName(), x, y + fieldLength));
            }
        }
    }

    private void doPaintProvinceBorder(Field field, int x, int y, int fieldLength) {
        byte nationNr = field.getProvince().getNation();
        this.g.setColor(Color.decode(Main.cfg_color_nation_inter.get(nationNr)));
        if (field.isProvincialBorder(5)) {
            this.g.drawLine(x, y, x + fieldLength / 2, y);
        }
        if (field.isProvincialBorder(4)) {
            this.g.drawLine(x, y, x, y + fieldLength - 1);
        }
        if (field.isProvincialBorder(0)) {
            this.g.drawLine(x + fieldLength / 2, y, x + fieldLength - 1, y);
        }
    }

    private void doPaintNationalBorder(Field field, int x, int y, int fieldLength) {
        byte nationNr = field.getProvince().getNation();
        this.g.setColor(Color.decode(Main.cfg_color_nation_outer.get(nationNr)));
        if (field.isNationalBorder(5)) {
            this.g.drawLine(x, y, x + fieldLength / 2 + 1, y);
            this.g.drawLine(x, y + 1, x + fieldLength / 2, y + 1);
        }
        if (field.isNationalBorder(4)) {
            this.g.drawLine(x, y, x, y + fieldLength - 1);
            this.g.drawLine(x + 1, y, x + 1, y + fieldLength - 1);
        }
        if (field.isNationalBorder(3)) {
            this.g.drawLine(x, y + fieldLength - 2, x + fieldLength / 2, y + fieldLength - 2);
            this.g.drawLine(x, y + fieldLength - 1, x + fieldLength / 2 + 1, y + fieldLength - 1);
        }
        if (field.isNationalBorder(2)) {
            this.g.drawLine(x + fieldLength / 2, y + fieldLength - 2, x + fieldLength - 1, y + fieldLength - 2);
            this.g.drawLine(x + fieldLength / 2 - 1, y + fieldLength - 1, x + fieldLength - 1, y + fieldLength - 1);
        }
        if (field.isNationalBorder(1)) {
            this.g.drawLine(x + fieldLength - 1, y, x + fieldLength - 1, y + fieldLength - 1);
            this.g.drawLine(x + fieldLength - 2, y, x + fieldLength - 2, y + fieldLength - 1);
        }
        if (field.isNationalBorder(0)) {
            this.g.drawLine(x + fieldLength / 2 - 1, y, x + fieldLength - 1, y);
            this.g.drawLine(x + fieldLength / 2, y + 1, x + fieldLength - 1, y + 1);
        }
    }

    private void writeAnalyseByteFeld(Field feld, int posByte, int ignoreValue, int posX, int posY) {
        byte value;
        if (posByte >= 0 && 35 >= posByte && (value = feld.getFullByte()[posByte]) != ignoreValue) {
            this.g.drawString("" + value, posX, posY);
        }
    }

    private void writeAnalyseByteProvinz(Province provinz, int posByte, int ignoreValue, int posX, int posY) {
        byte value;
        if (posByte >= 0 && 164 >= posByte && (value = provinz.getFullByte()[posByte]) != ignoreValue) {
            this.g.drawString("" + value, posX, posY);
        }
    }

    private void writeAnalyseByteProvinz(Province provinz, int posByte1, int posByte2, int ignoreValue, int posX, int posY) {
        byte[] fullByte;
        int value;
        if (posByte1 >= 0 && 164 >= posByte1 && (value = Convert.toInt((fullByte = provinz.getFullByte())[posByte1], fullByte[posByte2])) != ignoreValue) {
            this.g.drawString("" + value, posX, posY);
        }
    }
}

