/*
 * Decompiled with CFR 0.152.
 */
package regius.mapeditorimp1;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import regius.mapeditorimp1.Enums;
import regius.mapeditorimp1.Language;
import regius.mapeditorimp1.Mapeditor;
import regius.mapeditorimp1.ReadImages;
import regius.tools.Loggen;
import regius.tools.Properties;

public class Main {
    public static final boolean testversion = false;
    public static Loggen log;
    public static Mapeditor mapeditor;
    public static int count_provinces;
    public static int map_fieldsX;
    public static int map_fieldsY;
    public static int fieldPixelMax;
    private static BufferedImage[] images;
    private static Properties properties;
    private static String cfg_filepath;
    public static String cfg_filepath_langu;
    public static File folder_languages;
    private static ArrayList<Language> languages;
    public static File cfg_filefolder;
    public static int cfg_loglevel;
    public static String cfg_logfile;
    public static int cfg_last_pos_x;
    public static int cfg_last_pos_y;
    public static ArrayList<String> cfg_color_nation_outer;
    public static ArrayList<String> cfg_color_nation_inter;
    private static boolean commandLine_has_help;
    public static FileNameExtensionFilter filterPng;
    public static FileNameExtensionFilter filterImp;

    static {
        count_provinces = 384;
        map_fieldsX = 108;
        map_fieldsY = 60;
        fieldPixelMax = 64;
        cfg_filepath = "MapEditorImp1.properties";
        cfg_filepath_langu = "DE.lang";
        folder_languages = new File("Data/language");
        languages = new ArrayList();
        cfg_loglevel = 0;
        cfg_logfile = "";
        cfg_last_pos_x = 0;
        cfg_last_pos_y = 0;
        cfg_color_nation_outer = new ArrayList();
        cfg_color_nation_inter = new ArrayList();
        commandLine_has_help = false;
        filterPng = new FileNameExtensionFilter("PNG Images", "png");
        filterImp = new FileNameExtensionFilter("Imp1 Savefile", "imp");
    }

    public static void main(String[] args) {
        long start = System.nanoTime();
        IOException e_io = null;
        try {
            properties = Main.readProperties(cfg_filepath);
        }
        catch (IOException e) {
            e_io = e;
        }
        ParseException e_p = null;
        try {
            Main.parse_commandLineArgs(args);
            if (commandLine_has_help) {
                Main.system_out_write_help();
                return;
            }
        }
        catch (ParseException e) {
            e_p = e;
        }
        log = cfg_logfile.isEmpty() ? new Loggen(cfg_loglevel) : new Loggen(cfg_loglevel, cfg_logfile);
        ReadImages readImages = new ReadImages();
        Thread readImagesTread = new Thread(readImages);
        readImagesTread.start();
        File[] fileArray = folder_languages.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file_language = fileArray[n2];
            if (!file_language.isDirectory() && file_language.getName().endsWith(".txt")) {
                try {
                    languages.add(new Language(file_language));
                }
                catch (IOException e) {
                    log.logError("Language-File not readable: " + file_language.getName(), e);
                }
            }
            ++n2;
        }
        if (e_io != null) {
            log.logWarning("Properties-File not found: " + cfg_filepath);
            log.logDebug("Properties-File not found: " + cfg_filepath, (Exception)((Object)e_p));
        }
        if (e_p != null) {
            log.logWarning("Properties error in " + cfg_filepath);
            log.logDebug("Properties error in " + cfg_filepath, (Exception)((Object)e_p));
        }
        try {
            readImagesTread.join();
            images = readImages.getVorlageBilder();
        }
        catch (InterruptedException e) {
            log.logError(e);
        }
        log.logDebug("Dauer Main.main(): " + Float.valueOf((System.nanoTime() - start) / 1000000L) + " Millis");
        mapeditor = new Mapeditor(cfg_filefolder);
    }

    public static File open_file_dialog(File defaultDir) {
        File selectedFile = null;
        JFileChooser chooser = new JFileChooser("Verzeichnis w\u00e4hlen");
        chooser.setDialogType(0);
        chooser.setFileSelectionMode(0);
        chooser.setCurrentDirectory(defaultDir);
        chooser.setVisible(true);
        int result = chooser.showOpenDialog(null);
        selectedFile = result == 0 ? chooser.getSelectedFile() : null;
        chooser.setVisible(false);
        return selectedFile;
    }

    public static File save_file_dialog(File defaultDir) {
        return Main.save_file_dialog(defaultDir, null);
    }

    public static File save_file_dialog(File defaultDir, String defaultFileName) {
        File selectedFile = null;
        JFileChooser chooser = new JFileChooser("Verzeichnis w\u00e4hlen");
        chooser.setDialogType(1);
        chooser.setFileSelectionMode(0);
        chooser.addChoosableFileFilter(filterImp);
        chooser.addChoosableFileFilter(filterPng);
        chooser.setCurrentDirectory(defaultDir);
        if (defaultFileName != null) {
            chooser.setSelectedFile(new File(defaultFileName));
        }
        chooser.setVisible(true);
        int result = chooser.showSaveDialog(null);
        selectedFile = result == 0 ? Main.addFileEnding(chooser.getSelectedFile(), chooser.getFileFilter()) : null;
        chooser.setVisible(false);
        return selectedFile;
    }

    private static File addFileEnding(File file, FileFilter filter) {
        File newFile = file;
        if (filter == filterPng || filter == filterImp) {
            String fileName = file.getName();
            String expectedEnding = ((FileNameExtensionFilter)filter).getExtensions()[0];
            if (!fileName.toLowerCase().endsWith(expectedEnding)) {
                fileName = String.valueOf(fileName) + "." + expectedEnding;
                newFile = new File(file.getParentFile(), fileName);
            }
        }
        return newFile;
    }

    private static Properties readProperties(String filepath) throws IOException, FileNotFoundException {
        Properties properties = new Properties(filepath);
        cfg_filepath_langu = properties.getProperty("lang_file", cfg_filepath_langu);
        cfg_filefolder = new File(properties.getProperty("file_folder", ""));
        cfg_loglevel = Integer.parseInt(properties.getProperty("log_level", "0"));
        cfg_logfile = properties.getProperty("log_file", "");
        cfg_last_pos_x = Integer.parseInt(properties.getProperty("last_pos_x", "0"));
        cfg_last_pos_y = Integer.parseInt(properties.getProperty("last_pos_y", "0"));
        cfg_color_nation_outer = new ArrayList(23);
        cfg_color_nation_outer.add(properties.getProperty("color_nation01_outer", "#FF0000"));
        cfg_color_nation_outer.add(properties.getProperty("color_nation02_outer", "#FF0000"));
        cfg_color_nation_outer.add(properties.getProperty("color_nation03_outer", "#FF0000"));
        cfg_color_nation_outer.add(properties.getProperty("color_nation04_outer", "#FF0000"));
        cfg_color_nation_outer.add(properties.getProperty("color_nation05_outer", "#FF0000"));
        cfg_color_nation_outer.add(properties.getProperty("color_nation06_outer", "#FF0000"));
        cfg_color_nation_outer.add(properties.getProperty("color_nation07_outer", "#FF0000"));
        cfg_color_nation_outer.add(properties.getProperty("color_nation08_outer", "#FF0000"));
        cfg_color_nation_outer.add(properties.getProperty("color_nation09_outer", "#FF0000"));
        cfg_color_nation_outer.add(properties.getProperty("color_nation10_outer", "#FF0000"));
        cfg_color_nation_outer.add(properties.getProperty("color_nation11_outer", "#FF0000"));
        cfg_color_nation_outer.add(properties.getProperty("color_nation12_outer", "#FF0000"));
        cfg_color_nation_outer.add(properties.getProperty("color_nation13_outer", "#FF0000"));
        cfg_color_nation_outer.add(properties.getProperty("color_nation14_outer", "#FF0000"));
        cfg_color_nation_outer.add(properties.getProperty("color_nation15_outer", "#FF0000"));
        cfg_color_nation_outer.add(properties.getProperty("color_nation16_outer", "#FF0000"));
        cfg_color_nation_outer.add(properties.getProperty("color_nation17_outer", "#FF0000"));
        cfg_color_nation_outer.add(properties.getProperty("color_nation18_outer", "#FF0000"));
        cfg_color_nation_outer.add(properties.getProperty("color_nation19_outer", "#FF0000"));
        cfg_color_nation_outer.add(properties.getProperty("color_nation20_outer", "#FF0000"));
        cfg_color_nation_outer.add(properties.getProperty("color_nation21_outer", "#FF0000"));
        cfg_color_nation_outer.add(properties.getProperty("color_nation22_outer", "#FF0000"));
        cfg_color_nation_outer.add(properties.getProperty("color_nation23_outer", "#FF0000"));
        cfg_color_nation_inter = new ArrayList(23);
        cfg_color_nation_inter.add(properties.getProperty("color_nation01_inter", "#FF0000"));
        cfg_color_nation_inter.add(properties.getProperty("color_nation02_inter", "#FF0000"));
        cfg_color_nation_inter.add(properties.getProperty("color_nation03_inter", "#FF0000"));
        cfg_color_nation_inter.add(properties.getProperty("color_nation04_inter", "#FF0000"));
        cfg_color_nation_inter.add(properties.getProperty("color_nation05_inter", "#FF0000"));
        cfg_color_nation_inter.add(properties.getProperty("color_nation06_inter", "#FF0000"));
        cfg_color_nation_inter.add(properties.getProperty("color_nation07_inter", "#FF0000"));
        cfg_color_nation_inter.add(properties.getProperty("color_nation08_inter", "#FF0000"));
        cfg_color_nation_inter.add(properties.getProperty("color_nation09_inter", "#FF0000"));
        cfg_color_nation_inter.add(properties.getProperty("color_nation10_inter", "#FF0000"));
        cfg_color_nation_inter.add(properties.getProperty("color_nation11_inter", "#FF0000"));
        cfg_color_nation_inter.add(properties.getProperty("color_nation12_inter", "#FF0000"));
        cfg_color_nation_inter.add(properties.getProperty("color_nation13_inter", "#FF0000"));
        cfg_color_nation_inter.add(properties.getProperty("color_nation14_inter", "#FF0000"));
        cfg_color_nation_inter.add(properties.getProperty("color_nation15_inter", "#FF0000"));
        cfg_color_nation_inter.add(properties.getProperty("color_nation16_inter", "#FF0000"));
        cfg_color_nation_inter.add(properties.getProperty("color_nation17_inter", "#FF0000"));
        cfg_color_nation_inter.add(properties.getProperty("color_nation18_inter", "#FF0000"));
        cfg_color_nation_inter.add(properties.getProperty("color_nation19_inter", "#FF0000"));
        cfg_color_nation_inter.add(properties.getProperty("color_nation20_inter", "#FF0000"));
        cfg_color_nation_inter.add(properties.getProperty("color_nation21_inter", "#FF0000"));
        cfg_color_nation_inter.add(properties.getProperty("color_nation22_inter", "#FF0000"));
        cfg_color_nation_inter.add(properties.getProperty("color_nation23_inter", "#FF0000"));
        return properties;
    }

    public static void writeProperties() {
        properties.putProperty("lang_file", Mapeditor.getLanguage().getFileName());
        cfg_last_pos_x = mapeditor.getView().getMarkedX();
        cfg_last_pos_y = mapeditor.getView().getMarkedY();
        properties.putProperty("last_pos_x", "" + cfg_last_pos_x);
        properties.putProperty("last_pos_y", "" + cfg_last_pos_y);
        try {
            properties.store();
        }
        catch (IOException e) {
            log.logError("Properties-File not writable: " + properties.getFile().getAbsolutePath(), e);
        }
    }

    public static BufferedImage getIcon() {
        return images[86];
    }

    public static BufferedImage getResImage(Enums.Resource res) {
        return switch (res) {
            case Enums.Resource.COTTON -> images[56];
            case Enums.Resource.WOOL__ -> images[74];
            case Enums.Resource.WOOD__ -> images[73];
            case Enums.Resource.COAL__ -> images[55];
            case Enums.Resource.IRON__ -> images[66];
            case Enums.Resource.HORSE_ -> images[65];
            case Enums.Resource.OIL___ -> images[75];
            case Enums.Resource.GRAIN_ -> images[63];
            case Enums.Resource.FRUIT_ -> images[59];
            case Enums.Resource.FISH__ -> images[57];
            case Enums.Resource.CATTLE -> images[67];
            case Enums.Resource.GEMS__ -> images[61];
            case Enums.Resource.GOLD__ -> images[62];
            case Enums.Resource.Arms -> images[72];
            case Enums.Resource.Can -> images[58];
            case Enums.Resource.Clothes -> images[54];
            case Enums.Resource.Fuel -> images[76];
            case Enums.Resource.Furniture -> images[60];
            case Enums.Resource.Lumber -> images[69];
            case Enums.Resource.Paper -> images[68];
            case Enums.Resource.Steel -> images[70];
            case Enums.Resource.Textil -> images[71];
            case Enums.Resource.Tools -> images[64];
            default -> null;
        };
    }

    public static BufferedImage getRailImage(int rail) {
        return switch (rail) {
            case 0 -> images[19];
            case 1 -> images[18];
            case 2 -> images[17];
            case 3 -> images[16];
            case 4 -> images[15];
            case 5 -> images[14];
            default -> null;
        };
    }

    public static BufferedImage getTerrainOverlayImage(Enums.TerrainOverlay terrainOverlay) {
        return switch (terrainOverlay) {
            case Enums.TerrainOverlay.OCEAN -> images[5];
            case Enums.TerrainOverlay.OCEAN_SANDBAR -> images[88];
            case Enums.TerrainOverlay.OCEAN_ISLAND_SMALL -> images[89];
            case Enums.TerrainOverlay.OCEAN_ISLAND_LARGE -> images[90];
            case Enums.TerrainOverlay.OCEAN_ISLAND_GROUP -> images[91];
            case Enums.TerrainOverlay.CLEAR -> images[0];
            case Enums.TerrainOverlay.COTTON -> images[9];
            case Enums.TerrainOverlay.CATTLE -> images[10];
            case Enums.TerrainOverlay.HORSE -> images[109];
            case Enums.TerrainOverlay.GRAIN -> images[7];
            case Enums.TerrainOverlay.ORCHARD -> images[8];
            case Enums.TerrainOverlay.WOOL -> images[13];
            case Enums.TerrainOverlay.HILL -> images[2];
            case Enums.TerrainOverlay.MOUNTAIN_0 -> images[3];
            case Enums.TerrainOverlay.MOUNTAIN_1 -> images[87];
            case Enums.TerrainOverlay.SWAMP -> images[4];
            case Enums.TerrainOverlay.DESERT -> images[6];
            case Enums.TerrainOverlay.TUNDRA -> images[12];
            case Enums.TerrainOverlay.FOREST -> images[1];
            case Enums.TerrainOverlay.SCRUB -> images[11];
            case Enums.TerrainOverlay.CLEAR_TOWN -> images[0];
            default -> null;
        };
    }

    public static BufferedImage getTerrainOverlayTransitionImage(Enums.TerrainOverlay terrainOverlay) {
        return switch (terrainOverlay) {
            case Enums.TerrainOverlay.COTTON -> images[100];
            case Enums.TerrainOverlay.CATTLE -> images[101];
            case Enums.TerrainOverlay.GRAIN -> images[98];
            case Enums.TerrainOverlay.ORCHARD -> images[99];
            case Enums.TerrainOverlay.WOOL -> images[104];
            case Enums.TerrainOverlay.HILL -> images[93];
            case Enums.TerrainOverlay.MOUNTAIN_0 -> images[94];
            case Enums.TerrainOverlay.MOUNTAIN_1 -> images[95];
            case Enums.TerrainOverlay.SWAMP -> images[96];
            case Enums.TerrainOverlay.DESERT -> images[97];
            case Enums.TerrainOverlay.TUNDRA -> images[103];
            case Enums.TerrainOverlay.FOREST -> images[92];
            case Enums.TerrainOverlay.SCRUB -> images[102];
            default -> null;
        };
    }

    public static BufferedImage getTerrainOverlayTransitionHMImage(Enums.TerrainOverlay terrainOverlay) {
        return switch (terrainOverlay) {
            case Enums.TerrainOverlay.WOOL -> images[106];
            case Enums.TerrainOverlay.HILL -> images[105];
            case Enums.TerrainOverlay.MOUNTAIN_0 -> images[107];
            case Enums.TerrainOverlay.MOUNTAIN_1 -> images[108];
            default -> null;
        };
    }

    public static BufferedImage getShore(Enums.ShoreImage shoreImage, boolean alternativVariant) {
        int internalImageId = 44;
        if (alternativVariant) {
            internalImageId += 3;
        }
        return switch (shoreImage) {
            case Enums.ShoreImage.Shore_Land -> images[internalImageId];
            case Enums.ShoreImage.Shore_Ocean0 -> images[internalImageId + 1];
            case Enums.ShoreImage.Shore_Ocean1 -> images[internalImageId + 2];
            case Enums.ShoreImage.RiverMouth_Land_Eh_El_SW_Wh -> images[50];
            case Enums.ShoreImage.RiverMouth_Land_NE_SE_Wl_NW -> images[53];
            case Enums.ShoreImage.RiverMouth_Ocean_NE_SE_Wl_Wh -> images[51];
            case Enums.ShoreImage.RiverMouth_Ocean_Eh_El_SW_NW -> images[52];
            default -> null;
        };
    }

    public static BufferedImage getRiverImage(int river) {
        BufferedImage bi = river > 10 && river < 43 ? images[river + 9] : (river >= 43 && river < 51 ? images[river - 7] : null);
        return bi;
    }

    public static BufferedImage getHarborImage() {
        return images[77];
    }

    public static BufferedImage getStationImage() {
        return images[78];
    }

    public static BufferedImage getGreatPowerCapitalCityImage() {
        return images[79];
    }

    public static BufferedImage getGreatpowerProvincialCityImage() {
        return images[80];
    }

    public static BufferedImage getSmallpowerCapitalCityImage() {
        return images[81];
    }

    public static BufferedImage getSmallpowerProvincialCityImage() {
        return images[82];
    }

    public static BufferedImage getFortressImage(int level) {
        return switch (level) {
            case 1 -> images[83];
            case 2 -> images[84];
            case 3 -> images[85];
            default -> null;
        };
    }

    public static BufferedImage resize(BufferedImage image, int width, int height) {
        BufferedImage bi = new BufferedImage(width, height, 3);
        Graphics2D g2d = bi.createGraphics();
        g2d.addRenderingHints(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
        g2d.drawImage(image, 0, 0, width, height, null);
        g2d.dispose();
        return bi;
    }

    public static ArrayList<Language> getLanguages() {
        return languages;
    }

    public static boolean parse_commandLineArgs(String[] args) throws ParseException {
        boolean help_printed = false;
        Options options = new Options();
        GnuParser parser = new GnuParser();
        OptionBuilder.hasArg();
        Option option_v = OptionBuilder.create((String)"v");
        OptionBuilder.hasArg();
        Option option_f = OptionBuilder.create((String)"f");
        OptionBuilder.hasArg();
        Option option_l = OptionBuilder.create((String)"l");
        OptionBuilder.hasOptionalArg();
        Option option_help = OptionBuilder.create((String)"help");
        options.addOption(option_help);
        options.addOption(option_v);
        options.addOption(option_f);
        options.addOption(option_l);
        CommandLine commandLine = parser.parse(options, args);
        if (commandLine.hasOption("help")) {
            commandLine_has_help = true;
        }
        if (commandLine.hasOption("v")) {
            cfg_loglevel = Integer.valueOf(commandLine.getOptionValue("v"));
        }
        if (commandLine.hasOption("l")) {
            cfg_logfile = commandLine.getOptionValue("l");
        }
        if (commandLine.hasOption("f") && !(cfg_filefolder = new File(commandLine.getOptionValue("f"))).exists()) {
            log.logWarning("File or directory doesn't exists: " + cfg_filefolder);
            cfg_filefolder = null;
        }
        return help_printed;
    }

    public static void system_out_write_help() {
        System.out.println("Aufruf: java -jar SpieleditorImperialismusI.jar [OPTIONEN]");
        System.out.println("Optionen sind");
        System.out.println("  -l FILE        Ausgabe in Logdatei FILE umlenken");
        System.out.println("  -f FILE|FOLDER Oeffne FILE beim Start, oder navigiere in Datei-Oeffnen-Dialog zu FOLDER");
        System.out.println("  -v 0|1|2|3|4   Logging-Level");
        System.out.println("                 0=Still");
        System.out.println("                 1=Fehler");
        System.out.println("                 2=Fehler, Warnungen");
        System.out.println("                 3=Fehler, Warnungen, Informationen");
        System.out.println("                 4=Fehler, Warnungen, Informationen, Debugging");
        System.out.println("  -help          diese Hilfe ausgeben");
        System.out.println("");
        System.out.println("Weiteres auf http://sei.bplaced.net/");
    }
}

