/*
 * Decompiled with CFR 0.152.
 */
package regius.mapeditorimp1;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JFrame;
import regius.mapeditorimp1.Frame_About;
import regius.mapeditorimp1.Frame_Analyse;
import regius.mapeditorimp1.Frame_Empire;
import regius.mapeditorimp1.Frame_Field;
import regius.mapeditorimp1.Frame_Province;
import regius.mapeditorimp1.Frame_Turn;
import regius.mapeditorimp1.GlobalActions;
import regius.mapeditorimp1.IF_Selfpainted;
import regius.mapeditorimp1.Language;
import regius.mapeditorimp1.Main;
import regius.mapeditorimp1.MapeditorMenuBar;
import regius.mapeditorimp1.SaveFile;
import regius.mapeditorimp1.View;

public class Mapeditor
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = -994955683347634230L;
    public static final String T000_TITEL = "Spieleditor - Imperialismus 1";
    public static final String T000_VERSI = "0.8";
    private Font standardFont;
    private int fontSizeMax = 12;
    private MapeditorMenuBar menubar;
    private SaveFile savefile;
    private View view;
    private File lastDirOrFile;
    private ArrayList<IF_Selfpainted> paintComponents = new ArrayList(2);
    private static Language language;

    public Mapeditor(File file) {
        super(T000_TITEL);
        File tmp_file;
        long start = System.nanoTime();
        this.setDefaultCloseOperation(3);
        this.requestFocus();
        this.setTitle(T000_TITEL);
        this.standardFont = new Font("SansSerif", 0, this.fontSizeMax);
        this.setLayout(new BorderLayout());
        this.setIconImage(Main.getIcon());
        this.menubar = new MapeditorMenuBar(this);
        this.setJMenuBar(this.menubar);
        this.lastDirOrFile = file != null ? file : new File(".");
        if (!this.lastDirOrFile.isFile() && (tmp_file = Main.open_file_dialog(this.lastDirOrFile)) != null) {
            this.lastDirOrFile = tmp_file;
        }
        this.open_file(this.lastDirOrFile);
        this.setLanguage(Main.cfg_filepath_langu);
        this.view = new View(this);
        this.view.setShowPName(true);
        this.add((Component)this.view, "Center");
        GlobalActions.getInstance(this).addGlobalActions((JComponent)this.getContentPane());
        this.view.moveBorder(999);
        Main.log.logInfo("====open====");
        this.setMinimumSize(new Dimension(380, 260));
        this.setExtendedState(6);
        this.setVisible(true);
        this.view.setVisible(true);
        Main.log.logDebug("Dauer new Mapeditor(): " + Float.valueOf((System.nanoTime() - start) / 1000000L) + " Millis");
    }

    @Override
    public void dispose() {
        Main.writeProperties();
        Mapeditor.disposeFrames();
        super.dispose();
    }

    public static void disposeFrames() {
        Frame_About.exit();
        Frame_Turn.exit();
        Frame_Field.exit();
        Frame_Province.exit();
        Frame_Analyse.exit();
        Frame_Empire.exit();
    }

    public void open_file(File file) {
        if (file != null) {
            this.lastDirOrFile = file;
            try {
                if (file.isFile()) {
                    if (this.savefile == null) {
                        this.savefile = new SaveFile(file);
                    } else {
                        this.savefile.open(file);
                    }
                    this.repaintAll();
                    this.menubar.setMenubarEnabled(true);
                } else {
                    this.menubar.setMenubarEnabled(false);
                }
                this.setTitle("Spieleditor - Imperialismus 1: " + file.getName());
            }
            catch (Exception e) {
                this.savefile = null;
                Main.log.logError(file.getAbsolutePath(), e);
            }
        }
    }

    public void saveFile(File file) {
        if (file != null) {
            try {
                if (file.getName().toLowerCase().endsWith(".png")) {
                    this.savefile.saveImage(file, this.view.getZoomedImage());
                } else {
                    this.savefile.save(file);
                }
            }
            catch (Exception e) {
                Main.log.logError(file.getAbsolutePath(), e);
            }
        }
    }

    public void saveUnknownData(File file) {
        if (file != null) {
            try {
                this.savefile.saveUnknownData(file.getAbsolutePath());
            }
            catch (Exception e) {
                Main.log.logError(file.getAbsolutePath(), e);
            }
        }
    }

    public final SaveFile getSavefile() {
        return this.savefile;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.menubar.oeffnen) {
            this.open_file(Main.open_file_dialog(this.lastDirOrFile));
        } else if (ae.getSource() == this.menubar.feld) {
            this.view.showFrame_Field(true);
        } else if (ae.getSource() == this.menubar.provinz) {
            this.view.showFrame_Provinz(true);
        } else if (ae.getSource() == this.menubar.runden_) {
            Frame_Turn.getInstance(this).setVisible(true);
        } else if (ae.getSource() == this.menubar.empire) {
            Frame_Empire.getInstance(this).setVisible(true);
        } else if (ae.getSource() == this.menubar.analyse) {
            Frame_Analyse.getInstance(this).setVisible(true);
        } else if (ae.getSource() == this.menubar.about) {
            Frame_About.getInstance(this).setVisible(true);
        } else if (ae.getSource() == this.menubar.beenden) {
            this.dispose();
        } else if (ae.getSource() == this.menubar.sich_as) {
            this.saveFile(Main.save_file_dialog(this.lastDirOrFile, this.lastDirOrFile.getName()));
        } else if (ae.getSource() == this.menubar.sich_un) {
            this.saveUnknownData(this.lastDirOrFile);
        } else if (ae.getSource() == this.menubar.sichern) {
            this.saveFile(this.lastDirOrFile);
        } else if (ae.getSource() == this.menubar.pname__) {
            boolean isShowProvinceName = this.menubar.pname__.getState();
            this.view.setShowPName(isShowProvinceName);
            Frame_Field.getInstance(this).setShowProvinceName(isShowProvinceName);
            this.repaintAll();
        } else if (ae.getSource() == this.menubar.nborder) {
            boolean isShowNationalBorder = this.menubar.nborder.getState();
            this.view.setShowNBorder(isShowNationalBorder);
            Frame_Field.getInstance(this).setShowProvinceBorder(isShowNationalBorder);
            this.repaintAll();
        } else if (ae.getSource() == this.menubar.pborder) {
            boolean isShowProvinceBorder = this.menubar.pborder.getState();
            this.view.setShowPBorder(isShowProvinceBorder);
            Frame_Field.getInstance(this).setShowProvinceBorder(isShowProvinceBorder);
            this.repaintAll();
        } else if (ae.getActionCommand().startsWith("LANGU")) {
            String command_langu = ae.getActionCommand().substring(5);
            for (Language s : Main.getLanguages()) {
                if (!s.getFileName().equalsIgnoreCase(command_langu)) continue;
                this.setLanguage(s);
            }
        }
    }

    public void addPaintComponent(IF_Selfpainted component) {
        this.paintComponents.add(component);
    }

    public void repaintAll() {
        Main.log.logDebug("Mapeditor.repaintAll()");
        for (IF_Selfpainted component : this.paintComponents) {
            if (!component.isVisible()) continue;
            component.selfpaintAll();
        }
    }

    public final Font getStandardFont() {
        return this.standardFont;
    }

    public View getView() {
        return this.view;
    }

    public static final Language getLanguage() {
        return language;
    }

    private void setLanguage(String file) {
        for (Language s : Main.getLanguages()) {
            if (!s.getFileName().equalsIgnoreCase(file)) continue;
            this.setLanguage(s);
        }
    }

    private void setLanguage(Language l) {
        boolean isInitial = false;
        if (language == null) {
            isInitial = true;
        }
        language = l;
        this.menubar.setLanguage(language);
        if (!isInitial) {
            this.refreshLanguageOfFrames();
        }
    }

    private void refreshLanguageOfFrames() {
        if (this.savefile != null) {
            Frame_Empire.getInstance(this).refreshLanguage(language);
            Frame_Field.getInstance(this).refreshLanguage(language);
            Frame_Turn.getInstance(this).refreshLanguage(language);
            Frame_Province.getInstance(this).refreshLanguage(language);
            Frame_About.getInstance(this).refreshLanguage(language);
        }
    }
}

