/*
 * Decompiled with CFR 0.152.
 */
package regius.mapeditorimp1;

import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import regius.mapeditorimp1.Language;
import regius.mapeditorimp1.Main;

public class MapeditorMenuBar
extends JMenuBar {
    private JMenu datei = new JMenu();
    private JMenu ansic = new JMenu();
    private JMenu optio = new JMenu();
    private JMenu hilfe = new JMenu();
    public final JMenuItem oeffnen = new JMenuItem();
    public final JMenuItem sichern = new JMenuItem();
    public final JMenuItem sich_as = new JMenuItem();
    public final JMenuItem sich_un = new JMenuItem("Sichere unbekannte Daten");
    public final JMenuItem beenden = new JMenuItem();
    public final JMenuItem provinz = new JMenuItem();
    public final JMenuItem feld = new JMenuItem();
    public final JMenuItem empire = new JMenuItem();
    public final JMenuItem runden_ = new JMenuItem();
    public final JMenuItem analyse = new JMenuItem("Analyse");
    public final JCheckBoxMenuItem pname__ = new JCheckBoxMenuItem();
    public final JCheckBoxMenuItem nborder = new JCheckBoxMenuItem();
    public final JCheckBoxMenuItem pborder = new JCheckBoxMenuItem();
    public final JMenu langList = new JMenu();
    public final JMenuItem about = new JMenuItem();

    public MapeditorMenuBar(ActionListener actionListener) {
        this.createMenubar(actionListener);
        this.initMenubar();
    }

    private void createMenubar(ActionListener actionListener) {
        this.oeffnen.addActionListener(actionListener);
        this.sichern.addActionListener(actionListener);
        this.sich_as.addActionListener(actionListener);
        this.beenden.addActionListener(actionListener);
        this.feld.addActionListener(actionListener);
        this.provinz.addActionListener(actionListener);
        this.pname__.addActionListener(actionListener);
        this.nborder.addActionListener(actionListener);
        this.pborder.addActionListener(actionListener);
        this.empire.addActionListener(actionListener);
        this.runden_.addActionListener(actionListener);
        if (Main.getLanguages().size() > 0) {
            this.optio.add(this.langList);
            for (Language s : Main.getLanguages()) {
                JMenuItem langu = new JMenuItem(s.getName());
                langu.addActionListener(actionListener);
                langu.setActionCommand("LANGU" + s.getFileName());
                this.langList.add(langu);
            }
        } else {
            Main.log.logWarning("keine Sprachdatei gefunden unter \\Data\\language");
        }
        this.about.addActionListener(actionListener);
        this.add(this.datei);
        this.add(this.ansic);
        this.add(this.optio);
        this.add(this.hilfe);
        this.datei.add(this.oeffnen);
        this.datei.add(this.sichern);
        this.datei.add(this.sich_as);
        this.datei.add(this.beenden);
        this.ansic.add(this.provinz);
        this.ansic.add(this.feld);
        this.ansic.add(this.runden_);
        this.ansic.add(this.pname__);
        this.ansic.add(this.nborder);
        this.ansic.add(this.pborder);
        this.ansic.add(this.empire);
        this.hilfe.add(this.about);
    }

    public void setLanguage(Language language) {
        this.setText(language);
        this.setLanguageMenusNotSelectable(language);
    }

    private void setLanguageMenusNotSelectable(Language language) {
        int i = 0;
        while (i < this.langList.getItemCount()) {
            JMenuItem m = this.langList.getItem(i);
            if (language.getName().equalsIgnoreCase(m.getText())) {
                m.setEnabled(false);
            } else {
                m.setEnabled(true);
            }
            ++i;
        }
    }

    private void setText(Language language) {
        this.datei.setText(language.getMEN_FILE());
        this.ansic.setText(language.getMEN_VIEW());
        this.optio.setText(language.getMEN_OPTION());
        this.hilfe.setText(language.getMEN_HELP());
        this.oeffnen.setText(language.getMEN_OPEN());
        this.sichern.setText(language.getMEN_SAVE());
        this.sich_as.setText(language.getMEN_SAVE_AS());
        this.beenden.setText(language.getMEN_EXIT());
        this.feld.setText(language.getMEN_FIELD());
        this.provinz.setText(language.getMEN_PROVINCE());
        this.pname__.setText(language.getMEN_PROVINCE_NAME());
        this.nborder.setText(language.getMEN_NATIONAL_BORDER());
        this.pborder.setText(language.getMEN_PROVINCE_BORDER());
        this.empire.setText(language.getMEN_EMPIRE());
        this.runden_.setText(language.getMEN_TURN());
        this.langList.setText(language.getMEN_LANGUAGE());
        this.about.setText(language.getMEN_ABOUT());
    }

    private void initMenubar() {
        this.pname__.setState(true);
    }

    public void setMenubarEnabled(boolean enable) {
        this.sichern.setEnabled(enable);
        this.sich_as.setEnabled(enable);
        this.provinz.setEnabled(enable);
        this.feld.setEnabled(enable);
        this.pname__.setEnabled(enable);
        this.nborder.setEnabled(enable);
        this.pborder.setEnabled(enable);
        this.empire.setEnabled(enable);
        this.sich_un.setEnabled(enable);
        this.runden_.setEnabled(enable);
    }
}

