/*
 * Decompiled with CFR 0.152.
 */
package regius.mapeditorimp1;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import regius.mapeditorimp1.Field;
import regius.mapeditorimp1.Frame_Field;
import regius.mapeditorimp1.GraphicsConfig;
import regius.mapeditorimp1.GraphicsWorker;
import regius.mapeditorimp1.IF_Selfpainted;
import regius.mapeditorimp1.Main;
import regius.mapeditorimp1.Mapeditor;

public class MiniMap
extends JPanel
implements IF_Selfpainted {
    private static final long serialVersionUID = 3223879970402308037L;
    private Frame_Field adj;
    private Mapeditor me;
    private GraphicsConfig gcMiniMap;

    public MiniMap(Mapeditor me, Frame_Field adj) {
        this.adj = adj;
        this.me = me;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int c = MiniMap.this.getFieldByPoint(e.getPoint());
                if (-1 != c) {
                    MiniMap.this.adj.toggleRail(c);
                    MiniMap.this.me.repaintAll();
                }
            }
        });
        this.gcMiniMap = new GraphicsConfig(true, false, false, me.getStandardFont(), Color.decode("#FFFFFF"), Main.fieldPixelMax);
        this.setPreferredSize(new Dimension(Main.fieldPixelMax * 3, Main.fieldPixelMax * 3));
        me.addPaintComponent(this);
    }

    private int getFieldByPoint(Point p) {
        int ty = p.y / Main.fieldPixelMax;
        int ex = p.x;
        int tx = -1;
        int c = -1;
        if (1 == ty) {
            if (Main.fieldPixelMax >= ex) {
                tx = 0;
            } else if (Main.fieldPixelMax * 2 <= ex) {
                tx = 1;
            }
        } else {
            tx = Main.fieldPixelMax + Main.fieldPixelMax / 2 >= ex ? 0 : 1;
        }
        if (tx == 0) {
            switch (ty) {
                case 0: {
                    c = 5;
                    break;
                }
                case 1: {
                    c = 4;
                    break;
                }
                case 2: {
                    c = 3;
                }
            }
        } else if (1 == tx) {
            switch (ty) {
                case 0: {
                    c = 0;
                    break;
                }
                case 1: {
                    c = 1;
                    break;
                }
                case 2: {
                    c = 2;
                }
            }
        }
        return c;
    }

    public void setShowProvinceName(boolean showProvinceName) {
        this.gcMiniMap.setShowProvinceName(showProvinceName);
    }

    public void setShowProvinceBorder(boolean showProvinceBorder) {
        this.gcMiniMap.setShowProvinceBorder(showProvinceBorder);
    }

    public void setShowNationalBorder(boolean shwoNationalBorder) {
        this.gcMiniMap.setShowNationalBorder(shwoNationalBorder);
    }

    @Override
    public void paintComponent(Graphics g) {
        GraphicsWorker graphicsWorker = new GraphicsWorker(g, this.gcMiniMap, this);
        if (this.adj.getField() != null && this.adj.getField().getFieldsSurrounding() != null) {
            g.setColor(Color.decode("#EEEEEE"));
            g.fillRect(0, 0, Main.fieldPixelMax * 3, Main.fieldPixelMax * 3);
            int pixelPosX = Main.fieldPixelMax;
            int pixelPosY = Main.fieldPixelMax;
            graphicsWorker.doPaintField(this.adj.getField(), pixelPosX, pixelPosY);
            int fieldPosDirection = 0;
            while (fieldPosDirection < 6) {
                Field field_Surrounding = this.adj.getField().getFieldsSurrounding()[fieldPosDirection];
                if (field_Surrounding != null) {
                    switch (fieldPosDirection) {
                        case 5: {
                            pixelPosY = 0;
                            pixelPosX = Main.fieldPixelMax / 2;
                            break;
                        }
                        case 4: {
                            pixelPosY = Main.fieldPixelMax;
                            pixelPosX = 0;
                            break;
                        }
                        case 3: {
                            pixelPosY = Main.fieldPixelMax * 2;
                            pixelPosX = Main.fieldPixelMax / 2;
                            break;
                        }
                        case 2: {
                            pixelPosY = Main.fieldPixelMax * 2;
                            pixelPosX = Main.fieldPixelMax + Main.fieldPixelMax / 2;
                            break;
                        }
                        case 1: {
                            pixelPosY = Main.fieldPixelMax;
                            pixelPosX = Main.fieldPixelMax * 2;
                            break;
                        }
                        case 0: {
                            pixelPosY = 0;
                            pixelPosX = Main.fieldPixelMax + Main.fieldPixelMax / 2;
                            break;
                        }
                    }
                    graphicsWorker.doPaintField(field_Surrounding, pixelPosX, pixelPosY);
                }
                ++fieldPosDirection;
            }
            graphicsWorker.finish();
        }
    }

    @Override
    public void selfpaintAll() {
        this.repaint();
    }
}

