/*
 * Decompiled with CFR 0.152.
 */
package regius.mapeditorimp1;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import regius.mapeditorimp1.Empire;
import regius.mapeditorimp1.Field;
import regius.mapeditorimp1.Land;
import regius.mapeditorimp1.Main;
import regius.tools.Convert;

public class Province {
    private byte nation;
    private byte nation_original;
    private byte building;
    private byte fortressLevel;
    private int fieldNrOfCity;
    private int turn_connected;
    private byte[] unknown;
    private int ressTextil;
    private int ressLumber;
    private byte u136;
    private byte u137;
    private int resSteel;
    private int resFuel;
    private int resClothes;
    private int resFurniture;
    private int resTools;
    private byte[] unknown2;
    private byte name_len;
    private byte[] name;
    private int provinceId;
    private Field city;
    private Land land;
    private Empire empire;
    public static int minU04 = 9999;
    public static int maxU04 = 0;
    public static int minU05 = 9999;
    public static int maxU05 = 0;

    public Province(byte[] fullbyte, int provinceId) throws UnsupportedEncodingException {
        this.nation = fullbyte[0];
        this.nation_original = fullbyte[1];
        this.building = fullbyte[2];
        this.fortressLevel = fullbyte[3];
        this.fieldNrOfCity = this.nation >= 0 ? Convert.toInt(fullbyte[5], fullbyte[4]) : -1;
        this.turn_connected = Convert.toInt(fullbyte[7], fullbyte[6]);
        this.unknown = Convert.subBytes(fullbyte, 8, 124);
        Byte u09 = this.unknown[1];
        if (u09 != 0) {
            Main.log.logDebug("Province.Province(): u09 " + u09);
        }
        this.ressTextil = Convert.toInt(fullbyte[133], fullbyte[132]);
        this.ressLumber = Convert.toInt(fullbyte[135], fullbyte[134]);
        this.u136 = fullbyte[136];
        this.u137 = fullbyte[137];
        this.resSteel = Convert.toInt(fullbyte[139], fullbyte[138]);
        this.resFuel = Convert.toInt(fullbyte[141], fullbyte[140]);
        this.resClothes = Convert.toInt(fullbyte[143], fullbyte[142]);
        this.resFurniture = Convert.toInt(fullbyte[145], fullbyte[144]);
        this.resTools = Convert.toInt(fullbyte[147], fullbyte[146]);
        this.unknown2 = Convert.subBytes(fullbyte, 148, 16);
        this.name_len = fullbyte[164];
        this.name = Convert.subBytes(fullbyte, 165, this.name_len);
        this.provinceId = provinceId;
    }

    public final byte[] getFullByte() {
        ArrayList<Byte> blist = new ArrayList<Byte>();
        blist.add(this.nation);
        blist.add(this.nation_original);
        blist.add(this.building);
        blist.add(this.fortressLevel);
        blist.addAll(Convert.toBytes(this.fieldNrOfCity, 2, true));
        blist.addAll(Convert.toBytes(this.turn_connected, 2, true));
        Convert.addBytes(blist, this.unknown);
        blist.addAll(Convert.toBytes(this.ressTextil, 2, true));
        blist.addAll(Convert.toBytes(this.ressLumber, 2, true));
        blist.add(this.u136);
        blist.add(this.u137);
        blist.addAll(Convert.toBytes(this.resSteel, 2, true));
        blist.addAll(Convert.toBytes(this.resFuel, 2, true));
        blist.addAll(Convert.toBytes(this.resClothes, 2, true));
        blist.addAll(Convert.toBytes(this.resFurniture, 2, true));
        blist.addAll(Convert.toBytes(this.resTools, 2, true));
        Convert.addBytes(blist, this.unknown2);
        blist.add(this.name_len);
        Convert.addBytes(blist, this.name);
        return Convert.toBytes(blist);
    }

    private void checkNotValue(byte[] fullByte, byte notThisValue, int pos) {
        Byte originalByte = fullByte[pos];
        if (originalByte != notThisValue) {
            Main.log.logInfo("Province.checkNotValue(): Pos " + pos + " is Value " + Convert.toHexString(originalByte));
        }
    }

    public final Land getLand() {
        return this.land;
    }

    public final Empire getEmpire() {
        return this.empire;
    }

    public final void setEmpire(Empire empire) {
        this.empire = empire;
    }

    public final void setLand(Land land) {
        this.land = land;
    }

    public Field getCity() {
        return this.city;
    }

    public final void setCity(Field city) {
        this.city = city;
    }

    public final byte getNation() {
        return this.nation;
    }

    public final void setNation(byte nation) {
        this.nation = nation;
    }

    public final String getName() {
        return Convert.textISOtoUTF8_force(this.name);
    }

    public final void setName(String name) {
        try {
            this.name = name.getBytes("8859_1");
        }
        catch (Exception e) {
            Main.log.logError(e);
        }
        this.name_len = (byte)this.name.length;
    }

    public final byte getStufe_festung() {
        return this.fortressLevel;
    }

    public void setStufeFestung(int stufe_festung) {
        if (1 <= stufe_festung && 3 >= stufe_festung) {
            this.fortressLevel = (byte)stufe_festung;
            this.city.setFortress(true);
        } else {
            this.fortressLevel = 0;
            this.city.setFortress(false);
        }
    }

    public void setAnschlussCity(boolean anschluss, int runde) {
        this.turn_connected = anschluss ? 1 : 999;
    }

    public int getResTextil() {
        return this.ressTextil;
    }

    public int getResLumber() {
        return this.ressLumber;
    }

    public int getResSteel() {
        return this.resSteel;
    }

    public int getResFuel() {
        return this.resFuel;
    }

    public int getResClothes() {
        return this.resClothes;
    }

    public int getResFurniture() {
        return this.resFurniture;
    }

    public int getResTools() {
        return this.resTools;
    }

    public int getProvinceNumber() {
        return this.provinceId;
    }
}

