/*
 * Decompiled with CFR 0.152.
 */
package regius.mapeditorimp1;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.imageio.ImageIO;
import regius.mapeditorimp1.Empire;
import regius.mapeditorimp1.Field;
import regius.mapeditorimp1.Fieldtypes;
import regius.mapeditorimp1.Land;
import regius.mapeditorimp1.Main;
import regius.mapeditorimp1.Mapeditor;
import regius.mapeditorimp1.Province;
import regius.tools.Convert;
import regius.tools.Search;

public class SaveFile {
    public static final int POS_NW = 5;
    public static final int POS__W = 4;
    public static final int POS_SW = 3;
    public static final int POS_SE = 2;
    public static final int POS__E = 1;
    public static final int POS_NE = 0;
    private static Fieldtypes fieldtypes;
    private File file;
    private byte[] fileContent;
    private ArrayList<Byte> fileContentNeu;
    private ArrayList<ArrayList<Byte>> unknownData;
    private int fileLength;
    private int runde;
    private boolean isSzenario;
    private int start_feld;
    public Field[][] field = new Field[Main.map_fieldsY][Main.map_fieldsX];
    private ArrayList<Province> provinces = new ArrayList(Main.count_provinces);
    private ArrayList<Empire> empires;
    private ArrayList<Empire> empiresAlive;
    public ArrayList<Land> land;
    private ArrayList<Integer>[] landflags;
    private byte[][] landname_byte;
    private byte[][] landname_byte_pattern;
    private int posNachLandname;
    private byte[] spieler_land_byte;
    private String spieler_land;

    public SaveFile(File file) {
        try {
            fieldtypes = new Fieldtypes();
        }
        catch (Exception e) {
            fieldtypes = null;
            Main.log.logError(e);
        }
        this.open(file);
    }

    public final int getTurn() {
        return this.runde;
    }

    public final Field getField(int y, int x) {
        Field fi_return = null;
        if (y >= 0 && x >= 0 && Main.map_fieldsY > y && Main.map_fieldsX > x) {
            fi_return = this.field[y][x];
        }
        return fi_return;
    }

    public static final Fieldtypes getFieldtypes() {
        return fieldtypes;
    }

    public final boolean isSzenario() {
        return this.isSzenario;
    }

    public final void setTurn(int turn) {
        this.runde = turn;
    }

    public final void setField(Field[][] field) {
        this.field = field;
    }

    public void open(File f) {
        long start = System.nanoTime();
        if (f != null) {
            this.file = f;
            try {
                int mx;
                int strlen;
                this.unknownData = new ArrayList();
                this.empires = new ArrayList(7);
                this.empiresAlive = new ArrayList(7);
                this.land = new ArrayList(16);
                this.provinces = new ArrayList(Main.count_provinces);
                Mapeditor.disposeFrames();
                int pos_erstes_landflag = 0;
                int len_empires = 0;
                int len_land = 0;
                FileInputStream fis = new FileInputStream(f);
                this.fileLength = (int)f.length();
                this.fileContent = new byte[this.fileLength];
                fis.read(this.fileContent);
                fis.close();
                this.isSzenario = 24 == this.fileContent[59];
                Main.log.logDebug("Speicherbeginn Runde: 6564");
                this.runde = Convert.toInt(this.fileContent[6565], this.fileContent[6564]);
                Main.log.logDebug("Speicherbeginn Landnamen: 6701");
                int pos = 6701;
                this.landname_byte = new byte[23][];
                this.landname_byte_pattern = new byte[23][];
                int n = 0;
                while (n < 23) {
                    strlen = Convert.toInt(this.fileContent[pos]);
                    this.landname_byte[n] = new byte[strlen];
                    this.landname_byte_pattern[n] = new byte[2 * strlen + 2];
                    this.landname_byte[n] = Convert.subBytes(this.fileContent, pos + 1, strlen);
                    System.arraycopy(this.landname_byte[n], 0, this.landname_byte_pattern[n], 1, strlen);
                    System.arraycopy(this.landname_byte[n], 0, this.landname_byte_pattern[n], strlen + 2, strlen);
                    this.landname_byte_pattern[n][0] = (byte)strlen;
                    this.landname_byte_pattern[n][strlen + 1] = (byte)strlen;
                    pos += strlen + 1;
                    ++n;
                }
                this.posNachLandname = pos;
                Main.log.logDebug("SpeicherEnde L\u00e4nder: " + (this.posNachLandname - 1));
                this.landflags = Search.search(this.fileContent, this.landname_byte_pattern);
                int i = 0;
                while (i < 23) {
                    if (this.landflags[i].size() == 0) {
                        pos_begin = -1;
                    } else {
                        pos_begin = this.landflags[i].get(0);
                        if (pos_erstes_landflag == 0) {
                            pos_erstes_landflag = pos_begin;
                        }
                        int deadLandNotFullConquered = 1;
                        while (this.landflags.length - i - deadLandNotFullConquered > 0 && this.landflags[i + deadLandNotFullConquered].size() == 0) {
                            ++deadLandNotFullConquered;
                        }
                        int pos_ende = this.landflags.length - i - deadLandNotFullConquered > 0 ? this.landflags[i + deadLandNotFullConquered].get(0) : this.fileLength - 437;
                        int len = pos_ende - pos_begin;
                        if (7 > i) {
                            len_empires += len;
                            Main.log.logDebug("Next empire at: " + pos_begin);
                            Empire empire = new Empire(Convert.subBytes(this.fileContent, pos_begin, len), this);
                            this.empires.add(empire);
                            if (!empire.isDeadLandButNotFullConquered()) {
                                this.empiresAlive.add(empire);
                            }
                        } else {
                            len_land += len;
                            this.land.add(new Land(Convert.subBytes(this.fileContent, pos_begin, len)));
                        }
                    }
                    ++i;
                }
                Main.log.logDebug("Speicherbeginn Landname Spieler: 6528");
                this.spieler_land_byte = Convert.subBytes(this.fileContent, 6528, 20);
                this.spieler_land = new String(this.spieler_land_byte);
                boolean suche_start_feld = true;
                int n2 = 0;
                while (suche_start_feld && n2 < this.fileLength - 36) {
                    if (suche_start_feld && -1 == this.fileContent[n2 + 22] && this.fileContent[n2 + 23] == 0 && -1 == this.fileContent[n2 + 24] && -1 == this.fileContent[n2 + 26] && -1 == this.fileContent[n2 + 27] && this.fileContent[n2 + 28] == 0 && this.fileContent[n2 + 32] == 0 && this.fileContent[n2 + 33] == 0 && this.fileContent[n2 + 34] == 0 && this.fileContent[n2 + 35] == 0) {
                        this.start_feld = pos = n2;
                        suche_start_feld = false;
                    }
                    ++n2;
                }
                Main.log.logDebug("Speicherbeginn Felder: " + pos);
                int my = 0;
                while (my < Main.map_fieldsY) {
                    mx = 0;
                    while (mx < Main.map_fieldsX) {
                        this.field[my][mx] = new Field(Convert.subBytes(this.fileContent, pos, 36));
                        pos += 36;
                        ++mx;
                    }
                    ++my;
                }
                my = 0;
                while (my < Main.map_fieldsY) {
                    mx = 0;
                    while (mx < Main.map_fieldsX) {
                        Field tmp_field = this.field[my][mx];
                        tmp_field.setFieldsSurrounding(this.calcFieldsSurrounding(mx, my));
                        ++mx;
                    }
                    ++my;
                }
                Main.log.logDebug("Speicherbeginn Provinzen: " + pos);
                Province province = null;
                int provinceCount = 0;
                while (provinceCount < Main.count_provinces) {
                    strlen = Convert.toInt(this.fileContent[pos + 164]);
                    province = new Province(Convert.subBytes(this.fileContent, pos, 165 + strlen), provinceCount);
                    this.provinces.add(province);
                    pos += 165 + strlen;
                    ++provinceCount;
                }
                int my2 = 0;
                while (my2 < Main.map_fieldsY) {
                    int mx2 = 0;
                    while (mx2 < Main.map_fieldsX) {
                        Field tmpField = this.field[my2][mx2];
                        int provinceId = tmpField.getProvinceId();
                        Province tmpProvinz = Main.count_provinces <= provinceId ? null : this.provinces.get(provinceId);
                        if (!tmpField.isOcean()) {
                            tmpField.setProvince(tmpProvinz);
                        }
                        if (tmpField.isCity()) {
                            tmpProvinz.setCity(tmpField);
                        }
                        ++mx2;
                    }
                    ++my2;
                }
                int i2 = 0;
                while (i2 < 7 && i2 < this.empires.size()) {
                    Empire empire = this.empires.get(i2);
                    for (Province x : this.provinces) {
                        if (x.getNation() != empire.getNation()) continue;
                        x.setEmpire(empire);
                    }
                    ++i2;
                }
                this.unknownData.add(Convert.subList(this.fileContent, 0, 6528));
                this.unknownData.add(Convert.subList(this.fileContent, 6548, 16));
                this.unknownData.add(Convert.subList(this.fileContent, 6566, 135));
                this.unknownData.add(Convert.subList(this.fileContent, this.posNachLandname, this.start_feld - this.posNachLandname));
                if (1 > pos_erstes_landflag) {
                    Main.log.logDebug("SaveFile.open(): pos_erstes_landflag < 1: " + pos_erstes_landflag);
                }
                this.unknownData.add(Convert.subList(this.fileContent, pos, pos_erstes_landflag - pos));
                pos = pos_erstes_landflag + len_empires + len_land;
                this.unknownData.add(Convert.subList(this.fileContent, pos, this.fileLength - pos));
            }
            catch (Exception e) {
                Main.log.logError(this.file.getAbsolutePath(), e);
            }
        }
        Main.log.logDebug("Dauer SaveFile.open(): " + Float.valueOf((System.nanoTime() - start) / 1000000L) + " Millis");
    }

    public void save(File newFile) {
        if (newFile != null) {
            this.file = newFile;
            try {
                this.fileContentNeu = new ArrayList();
                this.fileContentNeu.addAll((Collection<Byte>)this.unknownData.get(0));
                Convert.addBytes(this.fileContentNeu, this.spieler_land_byte);
                this.fileContentNeu.addAll((Collection<Byte>)this.unknownData.get(1));
                this.fileContentNeu.addAll(Convert.toBytes(this.runde, 2, true));
                this.fileContentNeu.addAll((Collection<Byte>)this.unknownData.get(2));
                Object object = this.landname_byte;
                int n = this.landname_byte.length;
                int n2 = 0;
                while (n2 < n) {
                    byte[] by = object[n2];
                    this.fileContentNeu.add((byte)by.length);
                    Convert.addBytes(this.fileContentNeu, by);
                    ++n2;
                }
                this.fileContentNeu.addAll((Collection<Byte>)this.unknownData.get(3));
                object = this.field;
                n = this.field.length;
                n2 = 0;
                while (n2 < n) {
                    byte[] fy;
                    byte[] byArray = fy = object[n2];
                    int n3 = fy.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        byte f = byArray[n4];
                        Convert.addBytes(this.fileContentNeu, f.getFullByte());
                        ++n4;
                    }
                    ++n2;
                }
                for (Province p : this.provinces) {
                    Convert.addBytes(this.fileContentNeu, p.getFullByte());
                }
                this.fileContentNeu.addAll((Collection<Byte>)this.unknownData.get(4));
                for (Empire g : this.empires) {
                    Convert.addBytes(this.fileContentNeu, g.getFullByte());
                }
                for (Land l : this.land) {
                    Convert.addBytes(this.fileContentNeu, l.getFullByte());
                }
                this.fileContentNeu.addAll((Collection<Byte>)this.unknownData.get(5));
                Main.log.logInfo("Dateigr\u00f6\u00dfe ALT: " + this.fileContent.length);
                Main.log.logInfo("Dateigr\u00f6\u00dfe NEU: " + this.fileContentNeu.size());
                this.fileContent = new byte[this.fileContentNeu.size()];
                int n5 = 0;
                while (n5 < this.fileContentNeu.size()) {
                    this.fileContent[n5] = this.fileContentNeu.get(n5);
                    ++n5;
                }
                FileOutputStream fin = new FileOutputStream(this.file);
                fin.write(this.fileContent);
                fin.close();
            }
            catch (Exception e) {
                Main.log.logError(this.file.getAbsolutePath(), e);
            }
        }
    }

    public void saveUnknownData(String newFile) {
        int i = 0;
        while (i < this.unknownData.size()) {
            this.save_Data(String.valueOf(newFile) + "_" + i + ".part.imp", this.unknownData.get(i));
            ++i;
        }
    }

    private void save_Data(String newFile, ArrayList<Byte> data) {
        File file = new File(newFile);
        try {
            FileOutputStream fin = new FileOutputStream(file);
            byte[] fileContent = new byte[data.size()];
            int n = 0;
            while (n < data.size()) {
                fileContent[n] = data.get(n);
                ++n;
            }
            fin.write(fileContent);
            fin.close();
        }
        catch (Exception e) {
            Main.log.logDebug(e);
        }
    }

    public ArrayList<Empire> getEmpires() {
        return this.empires;
    }

    public ArrayList<Empire> getEmpiresAlive() {
        return this.empiresAlive;
    }

    public void saveImage(File file, BufferedImage karte) {
        if (karte != null && file != null) {
            try {
                ImageIO.write((RenderedImage)karte, "png", file);
            }
            catch (IOException e) {
                Main.log.logDebug(e);
            }
        }
    }

    private Field[] calcFieldsSurrounding(int posX, int posY) {
        Field[] uml = new Field[6];
        int lineKind = posY % 2;
        uml[0] = this.getField(posY - 1, posX + lineKind);
        uml[1] = this.getField(posY, posX + 1);
        uml[2] = this.getField(posY + 1, posX + lineKind);
        uml[3] = this.getField(posY + 1, posX - 1 + lineKind);
        uml[4] = this.getField(posY, posX - 1);
        uml[5] = this.getField(posY - 1, posX - 1 + lineKind);
        return uml;
    }
}

