/*
 * Decompiled with CFR 0.152.
 */
package regius.mapeditorimp1;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import javax.swing.JComponent;
import regius.mapeditorimp1.Field;
import regius.mapeditorimp1.Frame_Field;
import regius.mapeditorimp1.Frame_Province;
import regius.mapeditorimp1.GraphicsConfig;
import regius.mapeditorimp1.GraphicsWorker;
import regius.mapeditorimp1.IF_Selfpainted;
import regius.mapeditorimp1.Main;
import regius.mapeditorimp1.Mapeditor;
import regius.mapeditorimp1.SaveFile;
import regius.tools.FocusedListIterator;

public class View
extends JComponent
implements IF_Selfpainted {
    private int fieldVisibleX;
    private int fieldVisibleY;
    private int fieldVisibleFromX;
    private int fieldVisibleToX;
    private int fieldVisibleFromY;
    private int fieldVisibleToY;
    private Field fiMarked;
    private int fieldMarkedY = -1;
    private int fieldMarkedX = -1;
    private Mapeditor me;
    private GraphicsConfig gcViewImage;
    private int pixelSpaceLeft = 0;
    private int maxPixelX = Main.map_fieldsX * Main.fieldPixelMax + Main.fieldPixelMax / 2;
    private int maxPixelY = Main.map_fieldsY * Main.fieldPixelMax;
    private BufferedImage viewImage = new BufferedImage(this.maxPixelX, this.maxPixelY, 2);
    private Color colorTransparent = new Color(0xFFFFFF, true);
    private FocusedListIterator<Integer> zoom = new FocusedListIterator<Integer>(Arrays.asList(64, 56, 48, 40, 36, 32, 28, 24, 20, 16, 12));

    public View(Mapeditor me) {
        this.me = me;
        this.gcViewImage = new GraphicsConfig(true, false, false, me.getStandardFont(), Color.decode("#FFFFFF"), Main.fieldPixelMax);
        this.zoom.next();
        this.setLayout(null);
        Dimension maxDimension = new Dimension(this.maxPixelX, this.maxPixelY);
        this.setPreferredSize(maxDimension);
        this.setMaximumSize(maxDimension);
        MouseWheelListener mwl = new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.getWheelRotation() > 0) {
                    View.this.zoomOut();
                } else {
                    View.this.zoomIn();
                }
            }
        };
        this.addMouseWheelListener(mwl);
        MouseListener ml = new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseClicked(MouseEvent arg0) {
                View.this.markByKoord(arg0.getX(), arg0.getY());
            }
        };
        this.addMouseListener(ml);
        me.addPaintComponent(this);
        this.repaintImage();
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        int screenWidth = this.getWidth();
        int screenHeight = this.getHeight();
        g.clearRect(0, 0, screenWidth, screenHeight);
        this.calcVisibleSpot(screenWidth, screenHeight);
        int fieldLength = this.gcViewImage.getFieldLength();
        int spotWidth = fieldLength * this.fieldVisibleX + fieldLength / 2;
        int spotHeight = fieldLength * this.fieldVisibleY;
        this.pixelSpaceLeft = (screenWidth - spotWidth) / 2;
        int imgSpotFromPixelX = this.fieldVisibleFromX * fieldLength;
        int imgSpotToPixelX = (1 + this.fieldVisibleToX) * fieldLength + fieldLength / 2;
        int imgSpotFromPixelY = this.fieldVisibleFromY * fieldLength;
        int imgSpotToPixelY = (1 + this.fieldVisibleToY) * fieldLength;
        g.setColor(new Color(0, 255, 0, 0));
        g.drawImage(this.viewImage, this.pixelSpaceLeft, 0, this.pixelSpaceLeft + spotWidth, spotHeight, imgSpotFromPixelX, imgSpotFromPixelY, imgSpotToPixelX, imgSpotToPixelY, this);
        this.paintMarkedFieldBorder(g);
    }

    @Override
    public void selfpaintAll() {
        this.repaintImage();
        this.repaint();
    }

    private void repaintImage() {
        int fieldLength = this.gcViewImage.getFieldLength();
        Graphics2D g = this.viewImage.createGraphics();
        GraphicsWorker graphicsWorker = new GraphicsWorker(g, this.gcViewImage, this);
        SaveFile savefile = this.me.getSavefile();
        g.setBackground(this.colorTransparent);
        g.clearRect(0, 0, this.maxPixelX, this.maxPixelY);
        g.setColor(new Color(0, 255, 0, 0));
        if (savefile != null) {
            int fieldY = 0;
            while (fieldY < Main.map_fieldsY) {
                int addPixelPosX = fieldY % 2 == 0 ? 0 : fieldLength / 2;
                int pixelPosY = fieldLength * fieldY;
                int fieldX = 0;
                while (fieldX < Main.map_fieldsX) {
                    int pixelPosX = fieldLength * fieldX + addPixelPosX;
                    Field feld = savefile.getField(fieldY, fieldX);
                    graphicsWorker.doPaintField(feld, pixelPosX, pixelPosY);
                    ++fieldX;
                }
                ++fieldY;
            }
            graphicsWorker.finish();
        }
    }

    private void calcVisibleSpot(int possibleWidth, int possibleHeight) {
        int fieldLength = this.gcViewImage.getFieldLength();
        this.fieldVisibleX = (possibleWidth - fieldLength / 2) / fieldLength;
        this.fieldVisibleY = possibleHeight / fieldLength;
        if (this.fieldVisibleX > Main.map_fieldsX) {
            this.fieldVisibleX = Main.map_fieldsX;
        }
        if (this.fieldVisibleY > Main.map_fieldsY) {
            this.fieldVisibleY = Main.map_fieldsY;
        }
        this.fieldVisibleFromX = this.fieldMarkedX - this.fieldVisibleX / 2;
        this.fieldVisibleFromY = this.fieldMarkedY - this.fieldVisibleY / 2;
        this.fieldVisibleToX = this.fieldVisibleFromX + this.fieldVisibleX - 1;
        this.fieldVisibleToY = this.fieldVisibleFromY + this.fieldVisibleY - 1;
        if (this.fieldVisibleFromX < 0) {
            this.fieldVisibleToX -= this.fieldVisibleFromX;
            this.fieldVisibleFromX = 0;
        }
        if (this.fieldVisibleFromY < 0) {
            this.fieldVisibleToY -= this.fieldVisibleFromY;
            this.fieldVisibleFromY = 0;
        }
        if (this.fieldVisibleToX >= Main.map_fieldsX) {
            this.fieldVisibleFromX -= this.fieldVisibleToX - Main.map_fieldsX + 1;
            if (this.fieldVisibleFromX < 0) {
                this.fieldVisibleFromX = 0;
            }
            this.fieldVisibleToX = Main.map_fieldsX - 1;
        }
        if (this.fieldVisibleToY >= Main.map_fieldsY) {
            this.fieldVisibleFromY -= this.fieldVisibleToY - Main.map_fieldsY + 1;
            if (this.fieldVisibleFromY < 0) {
                this.fieldVisibleFromY = 0;
            }
            this.fieldVisibleToY = Main.map_fieldsY - 1;
        }
    }

    private void paintMarkedFieldBorder(Graphics g) {
        int fieldLength = this.gcViewImage.getFieldLength();
        int lineKind = this.fieldMarkedY % 2;
        int pixelPosX = fieldLength * (this.fieldMarkedX - this.fieldVisibleFromX) + lineKind * fieldLength / 2 + this.pixelSpaceLeft;
        int pixelPosY = fieldLength * (this.fieldMarkedY - this.fieldVisibleFromY);
        g.setColor(Color.WHITE);
        g.drawRect(pixelPosX, pixelPosY, fieldLength, fieldLength);
    }

    public BufferedImage getZoomedImage() {
        int fieldLength = this.gcViewImage.getFieldLength();
        int pixelX = Main.map_fieldsX * fieldLength + fieldLength / 2;
        int pixelY = Main.map_fieldsY * fieldLength;
        BufferedImage zoomedImage = new BufferedImage(pixelX, pixelY, 2);
        Graphics2D g = zoomedImage.createGraphics();
        g.drawImage(this.viewImage, 0, 0, pixelX, pixelY, 0, 0, pixelX, pixelY, null);
        return zoomedImage;
    }

    public void moveBorder(int direction) {
        switch (direction) {
            case 0: {
                break;
            }
            case 1: {
                if (Main.map_fieldsX - 1 <= this.fieldMarkedX) break;
                ++this.fieldMarkedX;
                break;
            }
            case 4: {
                if (this.fieldMarkedX <= 0) break;
                --this.fieldMarkedX;
                break;
            }
            case 5: {
                if (this.fieldMarkedY <= 0) break;
                --this.fieldMarkedY;
                break;
            }
            case 2: {
                if (Main.map_fieldsY - 1 <= this.fieldMarkedY) break;
                ++this.fieldMarkedY;
                break;
            }
            case 999: {
                this.fieldMarkedX = Main.cfg_last_pos_x;
                this.fieldMarkedY = Main.cfg_last_pos_y;
                break;
            }
            default: {
                this.fieldMarkedX = 0;
                this.fieldMarkedY = 0;
            }
        }
        this.mark(this.fieldMarkedX, this.fieldMarkedY);
    }

    private void markByKoord(int pixelPosX, int pixelPosY) {
        int fieldX;
        int fieldLength = this.gcViewImage.getFieldLength();
        int fieldY = pixelPosY / fieldLength + this.fieldVisibleFromY;
        int lineKind = 0;
        if (fieldY % 2 != 0) {
            lineKind = fieldLength / 2;
        }
        if ((fieldX = (pixelPosX - lineKind - this.pixelSpaceLeft) / fieldLength + this.fieldVisibleFromX) > this.fieldVisibleToX) {
            fieldX = this.fieldVisibleToX;
        } else if (fieldX < 0) {
            fieldX = this.fieldVisibleFromX;
        }
        if (fieldY > this.fieldVisibleToY) {
            fieldY = this.fieldVisibleToY;
        } else if (fieldY < 0) {
            fieldY = this.fieldVisibleFromY;
        }
        this.mark(fieldX, fieldY);
    }

    private void mark(int x, int y) {
        this.fieldMarkedX = x;
        this.fieldMarkedY = y;
        SaveFile savefile = this.me.getSavefile();
        if (savefile != null) {
            this.fiMarked = savefile.field[y][x];
            Main.log.logDebug("View.mark(): Koords " + x + "x" + y + " (" + (y * 108 + x) + "), ProvinceId " + this.fiMarked.getProvinceId());
        } else {
            this.fiMarked = null;
        }
        if (this.isVisible()) {
            this.refreshFrame_Feld();
            this.refreshFrame_Provinz();
            this.repaint();
        }
    }

    public int getMarkedX() {
        return this.fieldMarkedX;
    }

    public int getMarkedY() {
        return this.fieldMarkedY;
    }

    private void refreshFrame_Feld() {
        this.showFrame_Field(Frame_Field.getInstance(this.me).isVisible());
    }

    public void showFrame_Field(boolean show) {
        Frame_Field frame_Field = Frame_Field.getInstance(this.me);
        if (show && this.fiMarked != null) {
            frame_Field.init(this.fiMarked);
        }
        frame_Field.setVisible(show);
    }

    public void refreshFrame_Provinz() {
        this.showFrame_Provinz(Frame_Province.getInstance(this.me).isVisible());
    }

    public void showFrame_Provinz(boolean show) {
        Frame_Province frame_Provinz = Frame_Province.getInstance(this.me);
        if (show && this.fiMarked != null) {
            frame_Provinz.init(this.fiMarked);
        }
        frame_Provinz.setVisible(show);
    }

    public boolean isShowPName() {
        return this.gcViewImage.isShowProvinceName();
    }

    public void setShowPName(boolean showPName) {
        this.gcViewImage.setShowProvinceName(showPName);
    }

    public boolean isShowNBorder() {
        return this.gcViewImage.isShowNationalBorder();
    }

    public boolean isShowPBorder() {
        return this.gcViewImage.isShowProvinceBorder();
    }

    public void setShowNBorder(boolean showNBorder) {
        this.gcViewImage.setShowNationalBorder(showNBorder);
    }

    public void setShowPBorder(boolean showPBorder) {
        this.gcViewImage.setShowProvinceBorder(showPBorder);
    }

    public void zoomOut() {
        if (this.zoom.hasNext()) {
            this.setFieldLengthForZooming(this.zoom.next());
        }
    }

    public void zoomIn() {
        if (this.zoom.hasPrevious()) {
            this.setFieldLengthForZooming(this.zoom.previous());
        }
    }

    public void setFieldLengthForZooming(int fieldLength) {
        if (this.gcViewImage.setFieldLengthValidated(fieldLength, Main.fieldPixelMax / 8, Main.fieldPixelMax)) {
            int fieldLengthNew = this.gcViewImage.getFieldLength();
            int fontsize = fieldLengthNew <= Main.fieldPixelMax / 4 ? 8 : (fieldLengthNew <= Main.fieldPixelMax / 2 ? 9 : 12);
            this.gcViewImage.setFontProvinznameSize(fontsize);
            this.selfpaintAll();
        }
    }

    public void set_Borders(Field fi) {
        Field[] fieldsSurrounding = fi.getFieldsSurrounding();
        int i = 0;
        while (i < fieldsSurrounding.length) {
            Field ftmp = fieldsSurrounding[i];
            if (ftmp != null && !ftmp.isOcean()) {
                boolean isProvincialBorder = fi.getProvince() != ftmp.getProvince();
                fi.setProvincialBorder(i, isProvincialBorder);
                ftmp.setProvincialBorder((i + 3) % 6, isProvincialBorder);
                boolean isNationalBorder = fi.getNationNr2() != ftmp.getNationNr2();
                fi.setNationalBorder(i, isNationalBorder);
                ftmp.setNationalBorder((i + 3) % 6, isNationalBorder);
            }
            ++i;
        }
        this.setBordersCross(fi);
        this.setBordersCross(fieldsSurrounding[0]);
        this.setBordersCross(fieldsSurrounding[1]);
        this.setBordersCross(fieldsSurrounding[2]);
        this.setBordersCross(fieldsSurrounding[3]);
        this.setBordersCross(fieldsSurrounding[4]);
        this.setBordersCross(fieldsSurrounding[5]);
    }

    private void setBordersCross(Field fi) {
        Field[] fieldsSurrounding = fi.getFieldsSurrounding();
        Field fiNE = fieldsSurrounding[0];
        Field fiSE = fieldsSurrounding[2];
        if (fi != null && !fi.isOcean()) {
            if (fiNE != null) {
                if (fiNE.isProvincialBorder(2) && fi.isProvincialBorder(0) && fi.isProvincialBorder(1)) {
                    fi.setProvincialBorder(6, true);
                    if (fiNE.isNationalBorder(2) && fi.isNationalBorder(0) && fi.isNationalBorder(1)) {
                        fi.setNationalBorder(6, true);
                    }
                } else {
                    fi.setProvincialBorder(6, false);
                    fi.setNationalBorder(6, false);
                }
            }
            if (fiSE != null) {
                if (fiSE.isProvincialBorder(0) && fi.isProvincialBorder(2) && fi.isProvincialBorder(1)) {
                    fi.setProvincialBorder(7, true);
                    if (fiSE.isNationalBorder(0) && fi.isNationalBorder(2) && fi.isNationalBorder(1)) {
                        fi.setNationalBorder(7, true);
                    }
                } else {
                    fi.setProvincialBorder(7, false);
                    fi.setNationalBorder(7, false);
                }
            }
        }
    }
}

