/*
 * Decompiled with CFR 0.152.
 */
package regius.tools;

import java.awt.Color;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Convert {
    public static int toInt(byte b1) {
        return b1 & 0xFF;
    }

    public static int toInt(byte b1, byte b2) {
        int i1 = b1 & 0xFF;
        int i2 = b2 & 0xFF;
        return i1 * 256 + i2;
    }

    public static int toInt(byte b1, byte b2, byte b3) {
        int i1 = b1 & 0xFF;
        int i2 = b2 & 0xFF;
        int i3 = b3 & 0xFF;
        return i1 * 65536 + i2 * 256 + i3;
    }

    public static int toInt(byte b1, byte b2, byte b3, byte b4) {
        int i1 = b1 & 0xFF;
        int i2 = b2 & 0xFF;
        int i3 = b3 & 0xFF;
        int i4 = b4 & 0xFF;
        return i1 * 0x1000000 + i2 * 65536 + i3 * 256 + i4;
    }

    public static int toInt(byte[] b) throws IllegalArgumentException {
        if (8 < b.length) {
            throw new IllegalArgumentException("Byte-Array maximum Length is 8");
        }
        int i1 = 0;
        int n = 0;
        while (n < b.length) {
            int i2 = b[n] & 0xFF;
            i1 = i1 * 256 + i2;
            ++n;
        }
        return i1;
    }

    public static ByteBuffer toByteBuffer(List<Byte> byteList) {
        byte[] bytes = new byte[byteList.size()];
        int index = 0;
        Iterator<Byte> iterator = byteList.iterator();
        while (iterator.hasNext()) {
            bytes[index++] = iterator.next();
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        return byteBuffer;
    }

    public static short toShort(List<Byte> byteList) {
        List<Byte> internList = Convert.appendFirst(byteList, 2);
        return Convert.toByteBuffer(internList).getShort();
    }

    public static int toInt(List<Byte> byteList) {
        List<Byte> internList = Convert.appendFirst(byteList, 4);
        return Convert.toByteBuffer(internList).getInt();
    }

    public static long toLong(List<Byte> byteList) {
        List<Byte> internList = Convert.appendFirst(byteList, 8);
        return Convert.toByteBuffer(internList).getLong();
    }

    public static List<Byte> appendFirst(List<Byte> byteList, int minSize) {
        LinkedList<Byte> internList = new LinkedList<Byte>(byteList);
        int i = 0;
        while (i < minSize - byteList.size()) {
            internList.addFirst((byte)0);
            ++i;
        }
        return internList;
    }

    public static BitSet toBitSet(byte b, int len) {
        BitSet bs = new BitSet(len);
        int i = 0;
        while (i < len) {
            if ((b & 1 << i) > 0) {
                bs.set(i);
            }
            ++i;
        }
        return bs;
    }

    public static byte toByte(BitSet bs) {
        int i1 = 0;
        int i = 0;
        while (i < bs.length()) {
            if (bs.get(i)) {
                i1 |= 1 << i;
            }
            ++i;
        }
        return (byte)i1;
    }

    public static byte toByte(int i) throws IllegalArgumentException {
        if (255 < i || i < 0) {
            throw new IllegalArgumentException("int i maximum Length is 255, minimum Length is 0");
        }
        return (byte)i;
    }

    public static long byteToUnsignedLong(byte i) {
        return (long)i & 0xFFL;
    }

    public static long shortToUnsignedLong(short i) {
        return (long)i & 0xFFFFL;
    }

    public static long intToUnsignedLong(int i) {
        return (long)i & 0xFFFFFFFFL;
    }

    /*
     * Unable to fully structure code
     */
    public static ArrayList<Byte> toBytes(long signed_long, int minsize, boolean reverse) {
        block5: {
            bytes = new ArrayList<Byte>();
            bytes.add(0, (byte)(signed_long & 255L));
            if (signed_long < 0L) ** GOTO lbl12
            while (signed_long > 255L) {
                bytes.add(0, (byte)((signed_long >>= 8) & 255L));
            }
            while (minsize > bytes.size()) {
                bytes.add(0, (byte)0);
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                bytes.add(0, (byte)((signed_long >>= 8) & 255L));
lbl12:
                // 2 sources

                ** while (signed_long < -1L)
            }
lbl13:
            // 2 sources

            while (minsize > bytes.size()) {
                bytes.add(0, (byte)-1);
            }
        }
        if (reverse) {
            Collections.reverse(bytes);
        }
        return bytes;
    }

    public static ArrayList<Byte> toBytes(long signed_long, int minsize) {
        return Convert.toBytes(signed_long, minsize, false);
    }

    public static ArrayList<Byte> toBytes(long i) {
        return Convert.toBytes(i, 0, false);
    }

    public static byte[] toBytes(List<Byte> list) {
        return Convert.toByteBuffer(list).array();
    }

    public static byte[] subBytes(byte[] b, int offset, int len) {
        byte[] b1 = new byte[len];
        System.arraycopy(b, offset, b1, 0, len);
        return b1;
    }

    public static void addBytes(List<Byte> list, byte[] appending) {
        byte[] byArray = appending;
        int n = appending.length;
        int n2 = 0;
        while (n2 < n) {
            Byte b = byArray[n2];
            list.add(b);
            ++n2;
        }
    }

    public static void addSubBytes(List<Byte> list, byte[] appending, int offset, int len) {
        int n = 0;
        while (n < len) {
            list.add(appending[offset + n]);
            ++n;
        }
    }

    public static void replaceBytes(List<Byte> list, int offset, List<Byte> subList) {
        int len = subList.size();
        ArrayList<Byte> postList = Convert.subList(list, offset + len, list.size() - offset - len);
        ArrayList<Byte> preList = Convert.subList(list, 0, offset);
        list.clear();
        list.addAll(preList);
        list.addAll(subList);
        list.addAll(postList);
    }

    public static ArrayList<Byte> subList(List<Byte> list, int offset, int len) {
        ArrayList<Byte> newList = new ArrayList<Byte>(len);
        int n = offset;
        while (n < offset + len) {
            newList.add(list.get(n));
            ++n;
        }
        return newList;
    }

    public static ArrayList<Byte> subList(byte[] list, int offset, int len) {
        ArrayList<Byte> newList = new ArrayList<Byte>(len);
        int n = offset;
        while (n < offset + len) {
            newList.add(list[n]);
            ++n;
        }
        return newList;
    }

    public static String toHexString(byte[] val) {
        String s = "";
        byte[] byArray = val;
        int n = val.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            s = String.valueOf(s) + Convert.toHexString(b);
            ++n2;
        }
        return s;
    }

    public static String toHexString(byte val) {
        return Convert.toHexString(val, 2);
    }

    public static String toHexString(short val) {
        return Convert.toHexString(val, 4);
    }

    public static String toHexString(int val) {
        return Convert.toHexString(val, 8);
    }

    private static String toHexString(int val, int len) {
        String s = Integer.toHexString(val);
        int slen = s.length();
        if (len != slen) {
            if (len < slen) {
                s = s.substring(slen - len, slen);
            } else {
                while ((s = "0" + s).length() < len) {
                }
            }
        }
        return s;
    }

    public static String[] toArray(List<String> list) {
        String[] newList = new String[list.size()];
        int index = 0;
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            newList[index++] = iterator.next();
        }
        return newList;
    }

    public static ArrayList<String> toArrayList(String[] fileContent) {
        ArrayList<String> newList = new ArrayList<String>(fileContent.length);
        int i = 0;
        while (i < fileContent.length) {
            newList.add(fileContent[i]);
            ++i;
        }
        return newList;
    }

    public static ArrayList<Byte> toArrayList(byte[] b) {
        ArrayList<Byte> newList = new ArrayList<Byte>(b.length);
        int i = 0;
        while (i < b.length) {
            newList.add(b[i]);
            ++i;
        }
        return newList;
    }

    public static LinkedList<Byte> toLinkedList(byte[] b) {
        LinkedList<Byte> newList = new LinkedList<Byte>();
        int i = 0;
        while (i < b.length) {
            newList.add(b[i]);
            ++i;
        }
        return newList;
    }

    public static ArrayList<Object> toArrayList(Object[] list) {
        ArrayList<Object> newList = new ArrayList<Object>(list.length);
        int i = 0;
        while (i < list.length) {
            newList.add(list[i]);
            ++i;
        }
        return newList;
    }

    public static String textISOtoUTF8(byte[] b) throws UnsupportedEncodingException {
        return new String(b, "8859_1");
    }

    public static String textISOtoUTF8_force(byte[] b) {
        String s = null;
        try {
            s = Convert.textISOtoUTF8(b);
        }
        catch (UnsupportedEncodingException e) {
            s = new String(b);
        }
        return s;
    }

    public static String textUTF8toISO(byte[] b) throws UnsupportedEncodingException {
        return new String(b, "utf-8");
    }

    public static String textUTF8toISO_force(byte[] b) {
        String s = null;
        try {
            s = Convert.textUTF8toISO(b);
        }
        catch (UnsupportedEncodingException e) {
            s = new String(b);
        }
        return s;
    }

    public static String textISOtoUTF8(String iso) throws UnsupportedEncodingException {
        return new String(iso.getBytes("8859_1"), "utf-8");
    }

    public static Object dynamicConstructor(String className, String initialValue) {
        String classNameInternal = className.replaceFirst("class ", "");
        Object newObject = null;
        switch (classNameInternal) {
            case "int": {
                newObject = Integer.parseInt(initialValue);
                break;
            }
            case "java.awt.Color": {
                newObject = Color.decode(initialValue);
                break;
            }
            case "String": {
                newObject = new String(initialValue);
                break;
            }
            case "byte": {
                newObject = Byte.valueOf(initialValue);
            }
        }
        return newObject;
    }
}

