/*
 * Decompiled with CFR 0.152.
 */
package regius.tools;

public class Coordinate2D {
    public long level_south;
    public long level_east;
    public long level_southMin = Long.MIN_VALUE;
    public long level_eastMin = Long.MIN_VALUE;
    public long level_southMax = Long.MAX_VALUE;
    public long level_eastMax = Long.MAX_VALUE;

    public Coordinate2D() {
        this.level_south = 0L;
        this.level_east = 0L;
    }

    public Coordinate2D(long level_south, long level_east) {
        this.level_south = level_south;
        this.level_east = level_east;
    }

    public Coordinate2D(long level_south, long level_east, long level_southMin, long level_southMax, long level_eastMin, long level_eastMax) {
        this.level_south = level_south;
        this.level_east = level_east;
        this.level_southMin = level_southMin;
        this.level_southMax = level_southMax;
        this.level_eastMin = level_eastMin;
        this.level_eastMax = level_eastMax;
    }

    public Coordinate2D clone() {
        return new Coordinate2D(this.level_south, this.level_east, this.level_southMin, this.level_southMax, this.level_eastMin, this.level_eastMax);
    }

    public boolean equals(Coordinate2D k) {
        return this.level_south == k.level_south && this.level_east == k.level_east;
    }

    public boolean isInBounds() {
        return this.isInBound(this.level_south, this.level_southMin, this.level_southMax) && this.isInBound(this.level_east, this.level_eastMin, this.level_eastMax);
    }

    private boolean isInBound(long levelValue, long levelMin, long levelMax) {
        return levelValue >= levelMin && levelValue <= levelMax;
    }

    public String toString() {
        return "|" + this.level_south + "x" + this.level_east + "|";
    }

    public static enum GeographicDirection {
        NORTH,
        SOUTH,
        WEST,
        EAST;


        public Coordinate2D moveCoordinate2D(Coordinate2D coordinate) {
            Coordinate2D coordinateNew = coordinate.clone();
            switch (this) {
                case NORTH: {
                    --coordinateNew.level_south;
                    break;
                }
                case EAST: {
                    ++coordinateNew.level_east;
                    break;
                }
                case SOUTH: {
                    ++coordinateNew.level_south;
                    break;
                }
                case WEST: {
                    --coordinateNew.level_east;
                }
            }
            if (!coordinateNew.isInBounds()) {
                coordinateNew = null;
            }
            return coordinateNew;
        }
    }
}

