/*
 * Decompiled with CFR 0.152.
 */
package regius.tools;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JTextArea;

public class Loggen {
    public static final int LOGLEVEL_MUT = 0;
    public static final int LOGLEVEL_ERR = 1;
    public static final int LOGLEVEL_WAR = 2;
    public static final int LOGLEVEL_INF = 3;
    public static final int LOGLEVEL_DEB = 4;
    protected static final String PRE_INF = "INF";
    protected static final String PRE_WAR = "WAR";
    protected static final String PRE_ERR = "ERR";
    protected static final String PRE_DEB = "DEB";
    protected static SimpleDateFormat sdfDatumZeit = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.SSS");
    protected int loglevel_global;
    protected BufferedWriter bwlogdatei;
    protected JTextArea textArea;
    protected boolean logtoconsole = false;
    protected boolean logtofile = false;
    protected boolean logtotextarea = false;
    protected boolean logtotextareaOnTop = false;

    public Loggen(int loglevel, String filepath) {
        this(true, false, false, loglevel, filepath, null, false);
    }

    public Loggen(int loglevel, JTextArea textArea, boolean newTextOnTop) {
        this(false, true, false, loglevel, "", textArea, newTextOnTop);
    }

    public Loggen(int loglevel) {
        this(false, false, true, loglevel, "", null, false);
    }

    public Loggen() {
        this(false, false, true, 3, "", null, false);
    }

    private Loggen(boolean logtofile, boolean logtotextarea, boolean logtoconsole, int loglevel, String filepath, JTextArea textArea, boolean logtotextareaOnTop) {
        this.loglevel_global = loglevel;
        if (logtofile && this.loglevel_global > 0 && filepath != null && !filepath.equalsIgnoreCase("")) {
            this.logtofile = true;
            this.openLogfile(filepath);
        }
        if (logtotextarea && this.loglevel_global > 0 && textArea != null) {
            this.textArea = textArea;
            this.logtotextareaOnTop = logtotextareaOnTop;
            this.logtotextarea = true;
        }
        if (logtoconsole || !logtofile && !logtotextarea) {
            this.logtoconsole = true;
        }
    }

    protected void openLogfile(String filepath) {
        String text = String.valueOf(this.getClass().getName()) + ".openLogFile";
        try {
            this.bwlogdatei = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filepath, true)));
            text = String.valueOf(text) + " Erfolgreich ausgef\u00fchrt " + filepath;
            this.loggen(this.loglevel_global, PRE_INF, text);
        }
        catch (Exception e) {
            this.logtofile = false;
            this.bwlogdatei = null;
            text = String.valueOf(text) + " ERROR: " + e.getMessage();
            System.out.println(text);
        }
    }

    protected void loggen(int loglevel, String prefix, String text) {
        if (loglevel <= this.loglevel_global) {
            String logtext = String.valueOf(sdfDatumZeit.format(new Date())) + "_" + prefix + ": " + text;
            if (this.logtofile) {
                try {
                    this.bwlogdatei.write(logtext);
                    this.bwlogdatei.newLine();
                    this.bwlogdatei.flush();
                }
                catch (Exception e) {
                    System.out.println("LOG_ERROR: " + e.getMessage());
                }
            }
            if (this.logtotextarea) {
                if (this.logtotextareaOnTop) {
                    this.textArea.insert(String.valueOf(logtext) + System.getProperty("line.separator", "\r\n"), 0);
                } else {
                    this.textArea.append(String.valueOf(logtext) + System.getProperty("line.separator", "\r\n"));
                }
            }
            if (this.logtoconsole) {
                System.out.println(logtext);
            }
        }
    }

    public void logInfo(String text) {
        this.loggen(3, PRE_INF, text);
    }

    public void logWarning(String text) {
        this.loggen(2, PRE_WAR, text);
    }

    public void logError(String text) {
        this.loggen(1, PRE_ERR, text);
    }

    public void logError(String text, Exception e) {
        StackTraceElement ste = e.getStackTrace()[0];
        this.logError(String.valueOf(ste.toString()) + ": " + text + " " + e.getMessage());
        this.logDebug(e);
    }

    public void logError(Exception e) {
        StackTraceElement ste = e.getStackTrace()[0];
        this.logError(String.valueOf(ste.toString()) + ": " + e.getMessage());
        this.logDebug(e);
    }

    public void logDebug(String text) {
        this.loggen(4, PRE_DEB, text);
    }

    public void logDebug(Exception e) {
        this.logDebug(e.getMessage());
        StackTraceElement[] stackTraceElementArray = e.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement ste = stackTraceElementArray[n2];
            this.logDebug(ste.toString());
            ++n2;
        }
    }

    public void logDebug(String text, Exception e) {
        this.logDebug(String.valueOf(text) + " " + e.getMessage());
        StackTraceElement[] stackTraceElementArray = e.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement ste = stackTraceElementArray[n2];
            this.logDebug(ste.toString());
            ++n2;
        }
    }
}

