/*
 * Decompiled with CFR 0.152.
 */
package regius.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class Properties {
    private HashMap<String, String> values = new HashMap();
    private ArrayList<String> sort = new ArrayList();
    private File file;

    public Properties(String filepath) throws IOException {
        this(new File(filepath));
    }

    public Properties(File file) throws IOException {
        this();
        this.file = file;
        this.load(file);
    }

    public Properties() {
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void putProperty(String key, String value) {
        if (!this.values.containsKey(key)) {
            this.sort.add(key);
        }
        this.values.put(key, value);
    }

    public String getProperty(String key) {
        return this.values.get(key);
    }

    public String getProperty(String key, String defaultValue) {
        String value = this.getProperty(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public void store() throws IOException {
        this.store(this.file);
    }

    public void store(Path path) throws IOException {
        this.store(path.toFile());
    }

    public void store(String filepath) throws IOException {
        this.store(new File(filepath));
    }

    public void store(File file) throws IOException {
        PrintWriter pWriter = null;
        try {
            pWriter = new PrintWriter(new FileWriter(file));
            Iterator<String> iterator = this.sort.iterator();
            while (iterator.hasNext()) {
                String key;
                String line = key = iterator.next();
                if (!key.startsWith("#")) {
                    line = String.valueOf(line) + "=" + this.values.get(key);
                }
                pWriter.println(line);
            }
        }
        finally {
            if (pWriter != null) {
                pWriter.flush();
                pWriter.close();
            }
        }
    }

    private boolean load(File file) throws IOException {
        return this.load(Path.of(file.getAbsolutePath(), new String[0]));
    }

    private boolean load(Path path) throws IOException {
        boolean success = true;
        for (String line : Files.readAllLines(path)) {
            if (this.putLine(line)) continue;
            success = false;
        }
        return success;
    }

    private boolean putLine(String line) {
        boolean success;
        if (line.contentEquals("")) {
            success = true;
        } else if (line.startsWith("#")) {
            this.putProperty(line, "");
            success = true;
        } else if (!line.contains("=")) {
            this.putProperty("#" + line, "");
            success = false;
        } else {
            String[] splitted = line.split("=", 2);
            switch (splitted.length) {
                case 2: {
                    this.putProperty(splitted[0], splitted[1]);
                    success = true;
                    break;
                }
                case 1: {
                    this.putProperty(splitted[0], "");
                    success = true;
                    break;
                }
                default: {
                    success = false;
                }
            }
        }
        return success;
    }
}

