/*
 * Decompiled with CFR 0.152.
 */
package regius.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class Tree<T> {
    private T head;
    private ArrayList<Tree<T>> leafs = new ArrayList();
    private Tree<T> parent = null;
    private HashMap<T, Tree<T>> locate = new HashMap();
    private static final int indent = 2;

    public Tree(T head) {
        this.head = head;
        this.locate.put(head, this);
    }

    public void addLeaf(T root, T leaf) {
        if (this.locate.containsKey(root)) {
            this.locate.get(root).addLeaf(leaf);
        } else {
            this.addLeaf(root).addLeaf(leaf);
        }
    }

    public Tree<T> addLeaf(T leaf) {
        Tree<T> t = new Tree<T>(leaf);
        this.leafs.add(t);
        t.parent = this;
        t.locate = this.locate;
        this.locate.put(leaf, t);
        return t;
    }

    public Tree<T> setAsParent(T parentRoot) {
        Tree<T> t = new Tree<T>(parentRoot);
        t.leafs.add(this);
        this.parent = t;
        t.locate = this.locate;
        t.locate.put(this.head, this);
        t.locate.put(parentRoot, t);
        return t;
    }

    public T getHead() {
        return this.head;
    }

    public Tree<T> getTree(T element) {
        return this.locate.get(element);
    }

    public Tree<T> getParent() {
        return this.parent;
    }

    public Collection<T> getSuccessors(T root) {
        ArrayList<T> successors = new ArrayList<T>();
        Tree<T> tree = this.getTree(root);
        if (tree != null) {
            for (Tree<T> leaf : tree.leafs) {
                successors.add(leaf.head);
            }
        }
        return successors;
    }

    public Collection<T> getAllSuccessors(T root) {
        ArrayList<T> successors = new ArrayList<T>();
        Tree<T> tree = this.getTree(root);
        if (tree != null) {
            for (Tree<T> leaf : tree.leafs) {
                successors.add(leaf.head);
                successors.addAll(this.getAllSuccessors(leaf.head));
            }
        }
        return successors;
    }

    public Collection<Tree<T>> getSubTrees() {
        return this.leafs;
    }

    public int size() {
        return this.locate.size();
    }

    public int sizeOfSubtree() {
        int size = 1;
        for (Tree<T> leaf : this.leafs) {
            size += leaf.sizeOfSubtree();
        }
        return size;
    }

    public static <T> Collection<T> getSuccessors(T of, Collection<Tree<T>> in) {
        for (Tree<T> tree : in) {
            if (!tree.locate.containsKey(of)) continue;
            return tree.getSuccessors(of);
        }
        return new ArrayList();
    }

    public ArrayList<T> toArrayList() {
        return new ArrayList<T>(this.locate.keySet());
    }

    public String toString() {
        return this.printTree(0);
    }

    private String printTree(int increment) {
        String s = "";
        String inc = "";
        int i = 0;
        while (i < increment) {
            inc = String.valueOf(inc) + " ";
            ++i;
        }
        s = String.valueOf(inc) + this.head;
        for (Tree<T> child : this.leafs) {
            s = String.valueOf(s) + "\n" + child.printTree(increment + 2);
        }
        return s;
    }
}

