/*
 * Decompiled with CFR 0.152.
 */
package regius.unittest.tools;

import java.util.ArrayList;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import regius.tools.Tree;

public class TreeTest {
    Tree<String> tree = new Tree<String>("Root");

    public TreeTest() {
        this.tree.addLeaf("Leaf 0");
        this.tree.addLeaf("Leaf 1");
        String leaf = new String("Leaf 2");
        this.tree.addLeaf(leaf);
        this.tree.addLeaf(leaf, "Leaf 2-0");
    }

    @Test
    public void testToArrayList() {
        ArrayList<String> set = this.tree.toArrayList();
        if (set == null || 5 != set.size()) {
            Assert.fail((String)"toArrayList()");
        }
    }

    @Test
    public void testGetAllSuccessors() {
        Collection<String> stringList = this.tree.getAllSuccessors("Root");
        if (stringList.size() != 4) {
            Assert.fail((String)"GetAllSuccessors(\"Root\")");
        }
        if ((stringList = this.tree.getAllSuccessors("Leaf 0")).size() != 0) {
            Assert.fail((String)"GetAllSuccessors(\"Leaf 0\")");
        }
        if ((stringList = this.tree.getAllSuccessors("Leaf 2")).size() != 1) {
            Assert.fail((String)"GetAllSuccessors(\"Leaf 2\")");
        }
        if ((stringList = this.tree.getAllSuccessors("Leaf 2-0")).size() != 0) {
            Assert.fail((String)"GetAllSuccessors(\"Leaf 2-0\")");
        }
    }

    @Test
    public void testSize() {
        int size = this.tree.size();
        if (5 != size) {
            Assert.fail((String)("Size: " + size));
        }
        this.tree = this.tree.getTree("Leaf 2");
        size = this.tree.size();
        if (5 != size) {
            Assert.fail((String)("Size: " + size));
        }
    }

    @Test
    public void testSizeOfSubtree() {
        this.sub_SizeOfSubtree(this.tree, "Root", 5);
        this.sub_SizeOfSubtree(this.tree, "Leaf 0", 1);
        this.sub_SizeOfSubtree(this.tree, "Leaf 2", 2);
        this.sub_SizeOfSubtree(this.tree, "Leaf 2-0", 1);
    }

    private void sub_SizeOfSubtree(Tree<String> tree, String element, int expectedNumbersOfElements) {
        Tree<String> treeLeaf = tree.getTree(element);
        int size = treeLeaf.sizeOfSubtree();
        if (expectedNumbersOfElements != size) {
            Assert.fail((String)("SizeOfSubtree " + element + ": " + size));
        }
    }
}

